/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.util.Introspection;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.res.StringManager;

public class WebAnnotationSet {
    private static final String SEPARATOR = "/";
    private static final String MAPPED_NAME_PROPERTY = "mappedName";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        String[] applicationListeners;
        for (String className : applicationListeners = context.findApplicationListeners()) {
            Class<?> clazz = Introspection.loadClass(context, className);
            if (clazz == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        FilterDef[] filterDefs;
        for (FilterDef filterDef : filterDefs = context.findFilterDefs()) {
            Class<?> clazz = Introspection.loadClass(context, filterDef.getFilterClass());
            if (clazz == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        Container[] children2;
        for (Container child : children2 = context.findChildren()) {
            ServletSecurity servletSecurity;
            Class<?> clazz;
            Wrapper wrapper;
            if (!(child instanceof Wrapper) || (wrapper = (Wrapper)child).getServletClass() == null || (clazz = Introspection.loadClass(context, wrapper.getServletClass())) == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, clazz);
            WebAnnotationSet.loadFieldsAnnotation(context, clazz);
            WebAnnotationSet.loadMethodsAnnotation(context, clazz);
            RunAs runAs = clazz.getAnnotation(RunAs.class);
            if (runAs != null) {
                wrapper.setRunAs(runAs.value());
            }
            if ((servletSecurity = clazz.getAnnotation(ServletSecurity.class)) == null) continue;
            context.addServletSecurity(new ApplicationServletRegistration(wrapper, context), new ServletSecurityElement(servletSecurity));
        }
    }

    protected static void loadClassAnnotation(Context context, Class<?> clazz) {
        DeclareRoles declareRolesAnnotation;
        Resources resourcesAnnotation;
        Resource resourceAnnotation = clazz.getAnnotation(Resource.class);
        if (resourceAnnotation != null) {
            WebAnnotationSet.addResource(context, resourceAnnotation);
        }
        if ((resourcesAnnotation = clazz.getAnnotation(Resources.class)) != null && resourcesAnnotation.value() != null) {
            for (Resource resource2 : resourcesAnnotation.value()) {
                WebAnnotationSet.addResource(context, resource2);
            }
        }
        if ((declareRolesAnnotation = clazz.getAnnotation(DeclareRoles.class)) != null && declareRolesAnnotation.value() != null) {
            for (String role : declareRolesAnnotation.value()) {
                context.addSecurityRole(role);
            }
        }
    }

    protected static void loadFieldsAnnotation(Context context, Class<?> clazz) {
        Field[] fields = Introspection.getDeclaredFields(clazz);
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                Resource annotation = field.getAnnotation(Resource.class);
                if (annotation == null) continue;
                String defaultName = clazz.getName() + SEPARATOR + field.getName();
                Class<?> defaultType = field.getType();
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void loadMethodsAnnotation(Context context, Class<?> clazz) {
        Method[] methods2 = Introspection.getDeclaredMethods(clazz);
        if (methods2 != null && methods2.length > 0) {
            for (Method method : methods2) {
                Resource annotation = method.getAnnotation(Resource.class);
                if (annotation == null) continue;
                if (!Introspection.isValidSetter(method)) {
                    throw new IllegalArgumentException(sm.getString("webAnnotationSet.invalidInjection"));
                }
                String defaultName = clazz.getName() + SEPARATOR + Introspection.getPropertyName(method);
                Class<?> defaultType = method.getParameterTypes()[0];
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void addResource(Context context, Resource annotation) {
        WebAnnotationSet.addResource(context, annotation, null, null);
    }

    protected static void addResource(Context context, Resource annotation, String defaultName, Class<?> defaultType) {
        String name2 = WebAnnotationSet.getName(annotation, defaultName);
        String type2 = WebAnnotationSet.getType(annotation, defaultType);
        if (type2.equals("java.lang.String") || type2.equals("java.lang.Character") || type2.equals("java.lang.Integer") || type2.equals("java.lang.Boolean") || type2.equals("java.lang.Double") || type2.equals("java.lang.Byte") || type2.equals("java.lang.Short") || type2.equals("java.lang.Long") || type2.equals("java.lang.Float")) {
            ContextEnvironment resource2 = new ContextEnvironment();
            resource2.setName(name2);
            resource2.setType(type2);
            resource2.setDescription(annotation.description());
            resource2.setProperty(MAPPED_NAME_PROPERTY, annotation.mappedName());
            resource2.setLookupName(annotation.lookup());
            context.getNamingResources().addEnvironment(resource2);
        } else if (type2.equals("javax.xml.rpc.Service")) {
            ContextService service = new ContextService();
            service.setName(name2);
            service.setWsdlfile(annotation.mappedName());
            service.setType(type2);
            service.setDescription(annotation.description());
            service.setLookupName(annotation.lookup());
            context.getNamingResources().addService(service);
        } else if (type2.equals("javax.sql.DataSource") || type2.equals("javax.jms.ConnectionFactory") || type2.equals("javax.jms.QueueConnectionFactory") || type2.equals("javax.jms.TopicConnectionFactory") || type2.equals("javax.mail.Session") || type2.equals("java.net.URL") || type2.equals("javax.resource.cci.ConnectionFactory") || type2.equals("org.omg.CORBA_2_3.ORB") || type2.endsWith("ConnectionFactory")) {
            ContextResource resource3 = new ContextResource();
            resource3.setName(name2);
            resource3.setType(type2);
            if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resource3.setAuth("Container");
            } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resource3.setAuth("Application");
            }
            resource3.setScope(annotation.shareable() ? "Shareable" : "Unshareable");
            resource3.setProperty(MAPPED_NAME_PROPERTY, annotation.mappedName());
            resource3.setDescription(annotation.description());
            resource3.setLookupName(annotation.lookup());
            context.getNamingResources().addResource(resource3);
        } else if (type2.equals("javax.jms.Queue") || type2.equals("javax.jms.Topic")) {
            MessageDestinationRef resource4 = new MessageDestinationRef();
            resource4.setName(name2);
            resource4.setType(type2);
            resource4.setUsage(annotation.mappedName());
            resource4.setDescription(annotation.description());
            resource4.setLookupName(annotation.lookup());
            context.getNamingResources().addMessageDestinationRef(resource4);
        } else {
            ContextResourceEnvRef resource5 = new ContextResourceEnvRef();
            resource5.setName(name2);
            resource5.setType(type2);
            resource5.setProperty(MAPPED_NAME_PROPERTY, annotation.mappedName());
            resource5.setDescription(annotation.description());
            resource5.setLookupName(annotation.lookup());
            context.getNamingResources().addResourceEnvRef(resource5);
        }
    }

    private static String getType(Resource annotation, Class<?> defaultType) {
        Class<?> type2 = annotation.type();
        if ((type2 == null || type2.equals(Object.class)) && defaultType != null) {
            type2 = defaultType;
        }
        return Introspection.convertPrimitiveType(type2).getCanonicalName();
    }

    private static String getName(Resource annotation, String defaultName) {
        String name2 = annotation.name();
        if ((name2 == null || name2.equals("")) && defaultName != null) {
            name2 = defaultName;
        }
        return name2;
    }
}

