/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private final PrintWriter out;

    public DOMWriter(Writer writer2) {
        this.out = new PrintWriter(writer2);
    }

    public void print(Node node2) {
        if (node2 == null) {
            return;
        }
        short type2 = node2.getNodeType();
        switch (type2) {
            case 9: {
                this.print(((Document)node2).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                Attr[] attrs;
                this.out.print('<');
                this.out.print(node2.getLocalName());
                for (Attr attr : attrs = this.sortAttributes(node2.getAttributes())) {
                    this.out.print(' ');
                    this.out.print(attr.getLocalName());
                    this.out.print("=\"");
                    this.out.print(Escape.xml("", true, attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node2);
                break;
            }
            case 5: {
                this.printChildren(node2);
                break;
            }
            case 4: {
                this.out.print(Escape.xml("", true, node2.getNodeValue()));
                break;
            }
            case 3: {
                this.out.print(Escape.xml("", true, node2.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node2.getLocalName());
                String data2 = node2.getNodeValue();
                if (data2 != null && data2.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data2);
                }
                this.out.print("?>");
            }
        }
        if (type2 == 1) {
            this.out.print("</");
            this.out.print(node2.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node2) {
        NodeList children2 = node2.getChildNodes();
        if (children2 != null) {
            int len = children2.getLength();
            for (int i = 0; i < len; ++i) {
                this.print(children2.item(i));
            }
        }
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        if (attrs == null) {
            return new Attr[0];
        }
        int len = attrs.getLength();
        Attr[] array2 = new Attr[len];
        for (i = 0; i < len; ++i) {
            array2[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name2 = null;
            name2 = array2[i].getLocalName();
            int index2 = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = null;
                curName = array2[j].getLocalName();
                if (curName.compareTo(name2) >= 0) continue;
                name2 = curName;
                index2 = j;
            }
            if (index2 == i) continue;
            Attr temp = array2[i];
            array2[i] = array2[index2];
            array2[index2] = temp;
        }
        return array2;
    }
}

