/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected final Writer writer;

    public XMLWriter() {
        this(null);
    }

    public XMLWriter(Writer writer2) {
        this.writer = writer2;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String namespace2, String name2, String value) {
        this.writeElement(namespace2, name2, 0);
        this.buffer.append(value);
        this.writeElement(namespace2, name2, 1);
    }

    public void writeElement(String namespace2, String name2, int type2) {
        this.writeElement(namespace2, null, name2, type2);
    }

    public void writeElement(String namespace2, String namespaceInfo, String name2, int type2) {
        if (namespace2 != null && namespace2.length() > 0) {
            switch (type2) {
                case 0: {
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace2 + ":" + name2 + " xmlns:" + namespace2 + "=\"" + namespaceInfo + "\">");
                        break;
                    }
                    this.buffer.append("<" + namespace2 + ":" + name2 + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + namespace2 + ":" + name2 + ">\n");
                    break;
                }
                default: {
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace2 + ":" + name2 + " xmlns:" + namespace2 + "=\"" + namespaceInfo + "\"/>");
                        break;
                    }
                    this.buffer.append("<" + namespace2 + ":" + name2 + "/>");
                    break;
                }
            }
        } else {
            switch (type2) {
                case 0: {
                    this.buffer.append("<" + name2 + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + name2 + ">\n");
                    break;
                }
                default: {
                    this.buffer.append("<" + name2 + "/>");
                }
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public void writeData(String data2) {
        this.buffer.append("<![CDATA[" + data2 + "]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

