/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.catalina.webresources.VirtualResource;

public class FileResourceSet
extends AbstractFileResourceSet {
    public FileResourceSet() {
        super("/");
    }

    public FileResourceSet(WebResourceRoot root2, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root2);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }

    @Override
    public WebResource getResource(String path2) {
        this.checkPath(path2);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root2 = this.getRoot();
        if (path2.equals(webAppMount)) {
            File f = this.file("", true);
            if (f == null) {
                return new EmptyResource(root2, path2);
            }
            return new FileResource(root2, path2, f, this.isReadOnly(), null);
        }
        if (path2.charAt(path2.length() - 1) != '/') {
            path2 = path2 + '/';
        }
        if (webAppMount.startsWith(path2)) {
            String name2 = path2.substring(0, path2.length() - 1);
            if ((name2 = name2.substring(name2.lastIndexOf(47) + 1)).length() > 0) {
                return new VirtualResource(root2, path2, name2);
            }
        }
        return new EmptyResource(root2, path2);
    }

    @Override
    public String[] list(String path2) {
        String webAppMount;
        this.checkPath(path2);
        if (path2.charAt(path2.length() - 1) != '/') {
            path2 = path2 + '/';
        }
        if ((webAppMount = this.getWebAppMount()).startsWith(path2)) {
            if ((webAppMount = webAppMount.substring(path2.length())).equals(this.getFileBase().getName())) {
                return new String[]{this.getFileBase().getName()};
            }
            int i = webAppMount.indexOf(47);
            if (i > 0) {
                return new String[]{webAppMount.substring(0, i)};
            }
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path2) {
        String webAppMount;
        this.checkPath(path2);
        ResourceSet<String> result = new ResourceSet<String>();
        if (path2.charAt(path2.length() - 1) != '/') {
            path2 = path2 + '/';
        }
        if ((webAppMount = this.getWebAppMount()).startsWith(path2)) {
            if ((webAppMount = webAppMount.substring(path2.length())).equals(this.getFileBase().getName())) {
                result.add(path2 + this.getFileBase().getName());
            } else {
                int i = webAppMount.indexOf(47);
                if (i > 0) {
                    result.add(path2 + webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path2) {
        this.checkPath(path2);
        return false;
    }

    @Override
    public boolean write(String path2, InputStream is2, boolean overwrite) {
        this.checkPath(path2);
        return false;
    }

    @Override
    protected void checkType(File file2) {
        if (!file2.isFile()) {
            throw new IllegalArgumentException(sm.getString("fileResourceSet.notFile", this.getBase(), File.separator, this.getInternalPath()));
        }
    }
}

