/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MutableDynaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDynaBeanMapDecorator<K>
implements Map<K, Object> {
    private final DynaBean dynaBean;
    private final boolean readOnly;
    private transient Set<K> keySet;

    public BaseDynaBeanMapDecorator(DynaBean dynaBean) {
        this(dynaBean, true);
    }

    public BaseDynaBeanMapDecorator(DynaBean dynaBean, boolean readOnly) {
        if (dynaBean == null) {
            throw new IllegalArgumentException("DynaBean is null");
        }
        this.dynaBean = dynaBean;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key2) {
        DynaClass dynaClass = this.getDynaBean().getDynaClass();
        DynaProperty dynaProperty = dynaClass.getDynaProperty(this.toString(key2));
        return dynaProperty != null;
    }

    @Override
    public boolean containsValue(Object value) {
        DynaProperty[] properties = this.getDynaProperties();
        for (int i = 0; i < properties.length; ++i) {
            String key2 = properties[i].getName();
            Object prop = this.getDynaBean().get(key2);
            if (!(value == null ? prop == null : value.equals(prop))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, Object>> entrySet() {
        DynaProperty[] properties = this.getDynaProperties();
        HashSet<MapEntry<K>> set2 = new HashSet<MapEntry<K>>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            K key2 = this.convertKey(properties[i].getName());
            Object value = this.getDynaBean().get(properties[i].getName());
            set2.add(new MapEntry<K>(key2, value));
        }
        return Collections.unmodifiableSet(set2);
    }

    @Override
    public Object get(Object key2) {
        return this.getDynaBean().get(this.toString(key2));
    }

    @Override
    public boolean isEmpty() {
        return this.getDynaProperties().length == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        DynaProperty[] properties = this.getDynaProperties();
        Set<Object> set2 = new HashSet<K>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            set2.add(this.convertKey(properties[i].getName()));
        }
        set2 = Collections.unmodifiableSet(set2);
        DynaClass dynaClass = this.getDynaBean().getDynaClass();
        if (!(dynaClass instanceof MutableDynaClass)) {
            this.keySet = set2;
        }
        return set2;
    }

    @Override
    public Object put(K key2, Object value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        String property = this.toString(key2);
        Object previous = this.getDynaBean().get(property);
        this.getDynaBean().set(property, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Object> map2) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        for (Map.Entry<K, Object> e2 : map2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getDynaProperties().length;
    }

    @Override
    public Collection<Object> values() {
        DynaProperty[] properties = this.getDynaProperties();
        ArrayList<Object> values = new ArrayList<Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String key2 = properties[i].getName();
            Object value = this.getDynaBean().get(key2);
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public DynaBean getDynaBean() {
        return this.dynaBean;
    }

    protected abstract K convertKey(String var1);

    private DynaProperty[] getDynaProperties() {
        return this.getDynaBean().getDynaClass().getDynaProperties();
    }

    private String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntry<K>
    implements Map.Entry<K, Object> {
        private final K key;
        private final Object value;

        MapEntry(K key2, Object value) {
            this.key = key2;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o;
            return this.key.equals(e2.getKey()) && (this.value == null ? e2.getValue() == null : this.value.equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() + (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

