/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsBean {
    private static final ContextClassLoaderLocal<BeanUtilsBean> BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal<BeanUtilsBean>(){

        @Override
        protected BeanUtilsBean initialValue() {
            return new BeanUtilsBean();
        }
    };
    private final Log log = LogFactory.getLog(BeanUtils.class);
    private final ConvertUtilsBean convertUtilsBean;
    private final PropertyUtilsBean propertyUtilsBean;
    private static final Method INIT_CAUSE_METHOD = BeanUtilsBean.getInitCauseMethod();

    public static BeanUtilsBean getInstance() {
        return BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(BeanUtilsBean newInstance) {
        BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public BeanUtilsBean() {
        this(new ConvertUtilsBean(), new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean) {
        this(convertUtilsBean, new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        this.convertUtilsBean = convertUtilsBean;
        this.propertyUtilsBean = propertyUtilsBean;
    }

    public Object cloneBean(Object bean2) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cloning bean: " + bean2.getClass().getName());
        }
        DynaBean newBean = null;
        newBean = bean2 instanceof DynaBean ? ((DynaBean)bean2).getDynaClass().newInstance() : (DynaBean)bean2.getClass().newInstance();
        this.getPropertyUtils().copyProperties(newBean, bean2);
        return newBean;
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.copyProperties(" + dest + ", " + orig + ")");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name2 = origDescriptors[i].getName();
                if (!this.getPropertyUtils().isReadable(orig, name2) || !this.getPropertyUtils().isWriteable(dest, name2)) continue;
                Object value = ((DynaBean)orig).get(name2);
                this.copyProperty(dest, name2, value);
            }
        } else if (orig instanceof Map) {
            Map propMap = (Map)orig;
            for (Map.Entry entry : propMap.entrySet()) {
                String name3 = (String)entry.getKey();
                if (!this.getPropertyUtils().isWriteable(dest, name3)) continue;
                this.copyProperty(dest, name3, entry.getValue());
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyUtils().getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name4 = origDescriptors[i].getName();
                if ("class".equals(name4) || !this.getPropertyUtils().isReadable(orig, name4) || !this.getPropertyUtils().isWriteable(dest, name4)) continue;
                try {
                    Object value = this.getPropertyUtils().getSimpleProperty(orig, name4);
                    this.copyProperty(dest, name4, value);
                    continue;
                }
                catch (NoSuchMethodException e2) {
                    // empty catch block
                }
            }
        }
    }

    public void copyProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("  copyProperty(");
            sb.append(bean2);
            sb.append(", ");
            sb.append(name2);
            sb.append(", ");
            if (value == null) {
                sb.append("<NULL>");
            } else if (value instanceof String) {
                sb.append((String)value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                sb.append('[');
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                }
                sb.append(']');
            } else {
                sb.append(value.toString());
            }
            sb.append(')');
            this.log.trace(sb.toString());
        }
        Object target = bean2;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name2)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name2));
                name2 = resolver.remove(name2);
            }
            catch (NoSuchMethodException e2) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name2);
        }
        String propName = resolver.getProperty(name2);
        Class<?> type2 = null;
        int index2 = resolver.getIndex(name2);
        String key2 = resolver.getKey(name2);
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return;
            }
            type2 = BeanUtilsBean.dynaPropertyType(dynaProperty, value);
        } else {
            PropertyDescriptor descriptor2 = null;
            try {
                descriptor2 = this.getPropertyUtils().getPropertyDescriptor(target, name2);
                if (descriptor2 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException e3) {
                return;
            }
            type2 = descriptor2.getPropertyType();
            if (type2 == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("    target type for property '" + propName + "' is null, so skipping ths setter");
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    target propName=" + propName + ", type=" + type2 + ", index=" + index2 + ", key=" + key2);
        }
        if (index2 >= 0) {
            value = this.convertForCopy(value, type2.getComponentType());
            try {
                this.getPropertyUtils().setIndexedProperty(target, propName, index2, value);
            }
            catch (NoSuchMethodException e4) {
                throw new InvocationTargetException(e4, "Cannot set " + propName);
            }
        }
        if (key2 != null) {
            try {
                this.getPropertyUtils().setMappedProperty(target, propName, key2, value);
            }
            catch (NoSuchMethodException e5) {
                throw new InvocationTargetException(e5, "Cannot set " + propName);
            }
        }
        value = this.convertForCopy(value, type2);
        try {
            this.getPropertyUtils().setSimpleProperty(target, propName, value);
        }
        catch (NoSuchMethodException e6) {
            throw new InvocationTargetException(e6, "Cannot set " + propName);
        }
    }

    public Map<String, String> describe(Object bean2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            return new HashMap<String, String>();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Describing bean: " + bean2.getClass().getName());
        }
        HashMap<String, String> description = new HashMap<String, String>();
        if (bean2 instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean2).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name2 = descriptors[i].getName();
                description.put(name2, this.getProperty(bean2, name2));
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyUtils().getPropertyDescriptors(bean2);
            Class<?> clazz = bean2.getClass();
            for (int i = 0; i < descriptors.length; ++i) {
                String name3 = descriptors[i].getName();
                if (this.getPropertyUtils().getReadMethod(clazz, descriptors[i]) == null) continue;
                description.put(name3, this.getProperty(bean2, name3));
            }
        }
        return description;
    }

    public String[] getArrayProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getProperty(bean2, name2);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : (Collection)value) {
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(this.getConvertUtils().convert(item));
            }
            return values.toArray(new String[values.size()]);
        }
        if (value.getClass().isArray()) {
            int n = Array.getLength(value);
            String[] results = new String[n];
            for (int i = 0; i < n; ++i) {
                Object item = Array.get(value, i);
                results[i] = item == null ? null : this.getConvertUtils().convert(item);
            }
            return results;
        }
        String[] results = new String[]{this.getConvertUtils().convert(value)};
        return results;
    }

    public String getIndexedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getIndexedProperty(bean2, name2);
        return this.getConvertUtils().convert(value);
    }

    public String getIndexedProperty(Object bean2, String name2, int index2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getIndexedProperty(bean2, name2, index2);
        return this.getConvertUtils().convert(value);
    }

    public String getMappedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getMappedProperty(bean2, name2);
        return this.getConvertUtils().convert(value);
    }

    public String getMappedProperty(Object bean2, String name2, String key2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getMappedProperty(bean2, name2, key2);
        return this.getConvertUtils().convert(value);
    }

    public String getNestedProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getNestedProperty(bean2, name2);
        return this.getConvertUtils().convert(value);
    }

    public String getProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name2);
    }

    public String getSimpleProperty(Object bean2, String name2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getPropertyUtils().getSimpleProperty(bean2, name2);
        return this.getConvertUtils().convert(value);
    }

    public void populate(Object bean2, Map<String, ? extends Object> properties) throws IllegalAccessException, InvocationTargetException {
        if (bean2 == null || properties == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.populate(" + bean2 + ", " + properties + ")");
        }
        for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
            String name2 = entry.getKey();
            if (name2 == null) continue;
            this.setProperty(bean2, name2, entry.getValue());
        }
    }

    public void setProperty(Object bean2, String name2, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("  setProperty(");
            sb.append(bean2);
            sb.append(", ");
            sb.append(name2);
            sb.append(", ");
            if (value == null) {
                sb.append("<NULL>");
            } else if (value instanceof String) {
                sb.append((String)value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                sb.append('[');
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                }
                sb.append(']');
            } else {
                sb.append(value.toString());
            }
            sb.append(')');
            this.log.trace(sb.toString());
        }
        Object target = bean2;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name2)) {
            try {
                target = this.getPropertyUtils().getProperty(target, resolver.next(name2));
                if (target == null) {
                    return;
                }
                name2 = resolver.remove(name2);
            }
            catch (NoSuchMethodException e2) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + target);
            this.log.trace("    Target name = " + name2);
        }
        String propName = resolver.getProperty(name2);
        Class type2 = null;
        int index2 = resolver.getIndex(name2);
        String key2 = resolver.getKey(name2);
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return;
            }
            type2 = BeanUtilsBean.dynaPropertyType(dynaProperty, value);
        } else if (target instanceof Map) {
            type2 = Object.class;
        } else if (target != null && target.getClass().isArray() && index2 >= 0) {
            type2 = Array.get(target, index2).getClass();
        } else {
            PropertyDescriptor descriptor2 = null;
            try {
                descriptor2 = this.getPropertyUtils().getPropertyDescriptor(target, name2);
                if (descriptor2 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException e3) {
                return;
            }
            if (descriptor2 instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)descriptor2).getMappedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type2 = ((MappedPropertyDescriptor)descriptor2).getMappedPropertyType();
            } else if (index2 >= 0 && descriptor2 instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)descriptor2).getIndexedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type2 = ((IndexedPropertyDescriptor)descriptor2).getIndexedPropertyType();
            } else if (key2 != null) {
                if (descriptor2.getReadMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type2 = value == null ? Object.class : value.getClass();
            } else {
                if (descriptor2.getWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                type2 = descriptor2.getPropertyType();
            }
        }
        Object newValue = null;
        if (type2.isArray() && index2 < 0) {
            if (value == null) {
                String[] values = new String[]{null};
                newValue = this.getConvertUtils().convert(values, type2);
            } else {
                newValue = value instanceof String ? this.getConvertUtils().convert(value, type2) : (value instanceof String[] ? this.getConvertUtils().convert((String[])value, type2) : this.convert(value, type2));
            }
        } else {
            newValue = type2.isArray() ? (value instanceof String || value == null ? this.getConvertUtils().convert((String)value, type2.getComponentType()) : (value instanceof String[] ? this.getConvertUtils().convert(((String[])value)[0], type2.getComponentType()) : this.convert(value, type2.getComponentType()))) : (value instanceof String ? this.getConvertUtils().convert((String)value, type2) : (value instanceof String[] ? this.getConvertUtils().convert(((String[])value)[0], type2) : this.convert(value, type2)));
        }
        try {
            this.getPropertyUtils().setProperty(target, name2, newValue);
        }
        catch (NoSuchMethodException e4) {
            throw new InvocationTargetException(e4, "Cannot set " + propName);
        }
    }

    public ConvertUtilsBean getConvertUtils() {
        return this.convertUtilsBean;
    }

    public PropertyUtilsBean getPropertyUtils() {
        return this.propertyUtilsBean;
    }

    public boolean initCause(Throwable throwable, Throwable cause) {
        if (INIT_CAUSE_METHOD != null && cause != null) {
            try {
                INIT_CAUSE_METHOD.invoke((Object)throwable, cause);
                return true;
            }
            catch (Throwable e2) {
                return false;
            }
        }
        return false;
    }

    protected Object convert(Object value, Class<?> type2) {
        Converter converter = this.getConvertUtils().lookup(type2);
        if (converter != null) {
            this.log.trace("        USING CONVERTER " + converter);
            return converter.convert(type2, value);
        }
        return value;
    }

    private Object convertForCopy(Object value, Class<?> type2) {
        return value != null ? this.convert(value, type2) : value;
    }

    private static Method getInitCauseMethod() {
        try {
            Class[] paramsClasses = new Class[]{Throwable.class};
            return Throwable.class.getMethod("initCause", paramsClasses);
        }
        catch (NoSuchMethodException e2) {
            Log log = LogFactory.getLog(BeanUtils.class);
            if (log.isWarnEnabled()) {
                log.warn("Throwable does not have initCause() method in JDK 1.3");
            }
            return null;
        }
        catch (Throwable e3) {
            Log log = LogFactory.getLog(BeanUtils.class);
            if (log.isWarnEnabled()) {
                log.warn("Error getting the Throwable initCause() method", e3);
            }
            return null;
        }
    }

    private static Class<?> dynaPropertyType(DynaProperty dynaProperty, Object value) {
        if (!dynaProperty.isMapped()) {
            return dynaProperty.getType();
        }
        return value == null ? String.class : value.getClass();
    }
}

