/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JDBCDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    private boolean useColumnLabel;
    protected DynaProperty[] properties = null;
    protected Map<String, DynaProperty> propertiesMap = new HashMap<String, DynaProperty>();
    private Map<String, String> columnNameXref;

    JDBCDynaClass() {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public DynaProperty getDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.propertiesMap.get(name2);
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
    }

    protected Class<?> loadClass(String className) throws SQLException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return Class.forName(className, false, cl);
        }
        catch (Exception e2) {
            throw new SQLException("Cannot load column class '" + className + "': " + e2);
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        String name2;
        String columnName = null;
        if (this.useColumnLabel) {
            columnName = metadata.getColumnLabel(i);
        }
        if (columnName == null || columnName.trim().length() == 0) {
            columnName = metadata.getColumnName(i);
        }
        String string2 = name2 = this.lowerCase ? columnName.toLowerCase() : columnName;
        if (!name2.equals(columnName)) {
            if (this.columnNameXref == null) {
                this.columnNameXref = new HashMap<String, String>();
            }
            this.columnNameXref.put(name2, columnName);
        }
        String className = null;
        try {
            int sqlType = metadata.getColumnType(i);
            switch (sqlType) {
                case 91: {
                    return new DynaProperty(name2, Date.class);
                }
                case 93: {
                    return new DynaProperty(name2, Timestamp.class);
                }
                case 92: {
                    return new DynaProperty(name2, Time.class);
                }
            }
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e2) {
            // empty catch block
        }
        Class clazz = Object.class;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name2, clazz);
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        int i;
        ArrayList<DynaProperty> list = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int n = metadata.getColumnCount();
        for (i = 1; i <= n; ++i) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty == null) continue;
            list.add(dynaProperty);
        }
        this.properties = list.toArray(new DynaProperty[list.size()]);
        for (i = 0; i < this.properties.length; ++i) {
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
    }

    protected Object getObject(ResultSet resultSet, String name2) throws SQLException {
        DynaProperty property = this.getDynaProperty(name2);
        if (property == null) {
            throw new IllegalArgumentException("Invalid name '" + name2 + "'");
        }
        String columnName = this.getColumnName(name2);
        Class<?> type2 = property.getType();
        if (type2.equals(Date.class)) {
            return resultSet.getDate(columnName);
        }
        if (type2.equals(Timestamp.class)) {
            return resultSet.getTimestamp(columnName);
        }
        if (type2.equals(Time.class)) {
            return resultSet.getTime(columnName);
        }
        return resultSet.getObject(columnName);
    }

    protected String getColumnName(String name2) {
        if (this.columnNameXref != null && this.columnNameXref.containsKey(name2)) {
            return this.columnNameXref.get(name2);
        }
        return name2;
    }
}

