/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyDynaClass
extends BasicDynaClass
implements MutableDynaClass {
    protected boolean restricted;
    protected boolean returnNull = false;

    public LazyDynaClass() {
        this(null, (DynaProperty[])null);
    }

    public LazyDynaClass(String name2) {
        this(name2, (DynaProperty[])null);
    }

    public LazyDynaClass(String name2, Class<?> dynaBeanClass) {
        this(name2, dynaBeanClass, null);
    }

    public LazyDynaClass(String name2, DynaProperty[] properties) {
        this(name2, LazyDynaBean.class, properties);
    }

    public LazyDynaClass(String name2, Class<?> dynaBeanClass, DynaProperty[] properties) {
        super(name2, dynaBeanClass, properties);
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    @Override
    public void add(String name2) {
        this.add(new DynaProperty(name2));
    }

    @Override
    public void add(String name2, Class<?> type2) {
        if (type2 == null) {
            this.add(name2);
        } else {
            this.add(new DynaProperty(name2, type2));
        }
    }

    @Override
    public void add(String name2, Class<?> type2, boolean readable, boolean writeable) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    protected void add(DynaProperty property) {
        if (property.getName() == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        if (this.propertiesMap.get(property.getName()) != null) {
            return;
        }
        DynaProperty[] oldProperties = this.getDynaProperties();
        DynaProperty[] newProperties = new DynaProperty[oldProperties.length + 1];
        System.arraycopy(oldProperties, 0, newProperties, 0, oldProperties.length);
        newProperties[oldProperties.length] = property;
        this.setProperties(newProperties);
    }

    @Override
    public void remove(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        if (this.propertiesMap.get(name2) == null) {
            return;
        }
        DynaProperty[] oldProperties = this.getDynaProperties();
        DynaProperty[] newProperties = new DynaProperty[oldProperties.length - 1];
        int j = 0;
        for (int i = 0; i < oldProperties.length; ++i) {
            if (name2.equals(oldProperties[i].getName())) continue;
            newProperties[j] = oldProperties[i];
            ++j;
        }
        this.setProperties(newProperties);
    }

    @Override
    public DynaProperty getDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        DynaProperty dynaProperty = (DynaProperty)this.propertiesMap.get(name2);
        if (dynaProperty == null && !this.isReturnNull() && !this.isRestricted()) {
            dynaProperty = new DynaProperty(name2);
        }
        return dynaProperty;
    }

    public boolean isDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        return this.propertiesMap.get(name2) != null;
    }
}

