/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyDynaMap
extends LazyDynaBean
implements MutableDynaClass {
    protected String name;
    protected boolean restricted;
    protected boolean returnNull = false;

    public LazyDynaMap() {
        this(null, (Map<String, Object>)null);
    }

    public LazyDynaMap(String name2) {
        this(name2, (Map<String, Object>)null);
    }

    public LazyDynaMap(Map<String, Object> values) {
        this(null, values);
    }

    public LazyDynaMap(String name2, Map<String, Object> values) {
        this.name = name2 == null ? "LazyDynaMap" : name2;
        this.values = values == null ? this.newMap() : values;
        this.dynaClass = this;
    }

    public LazyDynaMap(DynaProperty[] properties) {
        this(null, properties);
    }

    public LazyDynaMap(String name2, DynaProperty[] properties) {
        this(name2, (Map<String, Object>)null);
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                this.add(properties[i]);
            }
        }
    }

    public LazyDynaMap(DynaClass dynaClass) {
        this(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public void setMap(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.values;
    }

    @Override
    public void set(String name2, Object value) {
        if (this.isRestricted() && !this.values.containsKey(name2)) {
            throw new IllegalArgumentException("Invalid property name '" + name2 + "' (DynaClass is restricted)");
        }
        this.values.put(name2, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DynaProperty getDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (!this.values.containsKey(name2) && this.isReturnNull()) {
            return null;
        }
        Object value = this.values.get(name2);
        if (value == null) {
            return new DynaProperty(name2);
        }
        return new DynaProperty(name2, value.getClass());
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        int i = 0;
        DynaProperty[] properties = new DynaProperty[this.values.size()];
        for (Map.Entry e2 : this.values.entrySet()) {
            String name2 = (String)e2.getKey();
            Object value = this.values.get(name2);
            properties[i++] = new DynaProperty(name2, value == null ? null : value.getClass());
        }
        return properties;
    }

    @Override
    public DynaBean newInstance() {
        Map newMap = null;
        try {
            Map temp;
            newMap = temp = (Map)this.getMap().getClass().newInstance();
        }
        catch (Exception ex) {
            newMap = this.newMap();
        }
        LazyDynaMap lazyMap = new LazyDynaMap(newMap);
        DynaProperty[] properties = this.getDynaProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                lazyMap.add(properties[i]);
            }
        }
        return lazyMap;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    @Override
    public void add(String name2) {
        this.add(name2, null);
    }

    @Override
    public void add(String name2, Class<?> type2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        Object value = this.values.get(name2);
        if (value == null) {
            this.values.put(name2, type2 == null ? null : this.createProperty(name2, type2));
        }
    }

    @Override
    public void add(String name2, Class<?> type2, boolean readable, boolean writeable) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    protected void add(DynaProperty property) {
        this.add(property.getName(), property.getType());
    }

    @Override
    public void remove(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        if (this.values.containsKey(name2)) {
            this.values.remove(name2);
        }
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    @Override
    protected boolean isDynaProperty(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        return this.values.containsKey(name2);
    }
}

