/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.ResultSetDynaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator
implements DynaBean,
Iterator<DynaBean> {
    protected boolean current = false;
    protected ResultSetDynaClass dynaClass = null;
    protected boolean eof = false;

    ResultSetIterator(ResultSetDynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    @Override
    public boolean contains(String name2, String key2) {
        throw new UnsupportedOperationException("FIXME - mapped properties not currently supported");
    }

    @Override
    public Object get(String name2) {
        if (this.dynaClass.getDynaProperty(name2) == null) {
            throw new IllegalArgumentException(name2);
        }
        try {
            return this.dynaClass.getObjectFromResultSet(name2);
        }
        catch (SQLException e2) {
            throw new RuntimeException("get(" + name2 + "): SQLException: " + e2);
        }
    }

    @Override
    public Object get(String name2, int index2) {
        throw new UnsupportedOperationException("FIXME - indexed properties not currently supported");
    }

    @Override
    public Object get(String name2, String key2) {
        throw new UnsupportedOperationException("FIXME - mapped properties not currently supported");
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name2, String key2) {
        throw new UnsupportedOperationException("FIXME - mapped operations not currently supported");
    }

    @Override
    public void set(String name2, Object value) {
        if (this.dynaClass.getDynaProperty(name2) == null) {
            throw new IllegalArgumentException(name2);
        }
        try {
            this.dynaClass.getResultSet().updateObject(name2, value);
        }
        catch (SQLException e2) {
            throw new RuntimeException("set(" + name2 + "): SQLException: " + e2);
        }
    }

    @Override
    public void set(String name2, int index2, Object value) {
        throw new UnsupportedOperationException("FIXME - indexed properties not currently supported");
    }

    @Override
    public void set(String name2, String key2, Object value) {
        throw new UnsupportedOperationException("FIXME - mapped properties not currently supported");
    }

    @Override
    public boolean hasNext() {
        try {
            this.advance();
            return !this.eof;
        }
        catch (SQLException e2) {
            throw new RuntimeException("hasNext():  SQLException:  " + e2);
        }
    }

    @Override
    public DynaBean next() {
        try {
            this.advance();
            if (this.eof) {
                throw new NoSuchElementException();
            }
            this.current = false;
            return this;
        }
        catch (SQLException e2) {
            throw new RuntimeException("next():  SQLException:  " + e2);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    protected void advance() throws SQLException {
        if (!this.current && !this.eof) {
            if (this.dynaClass.getResultSet().next()) {
                this.current = true;
                this.eof = false;
            } else {
                this.current = false;
                this.eof = true;
            }
        }
    }
}

