/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.WrapDynaClass;

public class WrapDynaBean
implements DynaBean,
Serializable {
    protected transient WrapDynaClass dynaClass = null;
    protected Object instance = null;

    public WrapDynaBean(Object instance) {
        this(instance, null);
    }

    public WrapDynaBean(Object instance, WrapDynaClass cls) {
        this.instance = instance;
        this.dynaClass = cls != null ? cls : (WrapDynaClass)this.getDynaClass();
    }

    public boolean contains(String name2, String key2) {
        throw new UnsupportedOperationException("WrapDynaBean does not support contains()");
    }

    public Object get(String name2) {
        Object value = null;
        try {
            value = this.getPropertyUtils().getSimpleProperty(this.instance, name2);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error reading property '" + name2 + "' nested exception - " + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error reading property '" + name2 + "', exception - " + t);
        }
        return value;
    }

    public Object get(String name2, int index2) {
        Object value = null;
        try {
            value = this.getPropertyUtils().getIndexedProperty(this.instance, name2, index2);
        }
        catch (IndexOutOfBoundsException e2) {
            throw e2;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error reading indexed property '" + name2 + "' nested exception - " + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error reading indexed property '" + name2 + "', exception - " + t);
        }
        return value;
    }

    public Object get(String name2, String key2) {
        Object value = null;
        try {
            value = this.getPropertyUtils().getMappedProperty(this.instance, name2, key2);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error reading mapped property '" + name2 + "' nested exception - " + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error reading mapped property '" + name2 + "', exception - " + t);
        }
        return value;
    }

    public DynaClass getDynaClass() {
        if (this.dynaClass == null) {
            this.dynaClass = WrapDynaClass.createDynaClass(this.instance.getClass());
        }
        return this.dynaClass;
    }

    public void remove(String name2, String key2) {
        throw new UnsupportedOperationException("WrapDynaBean does not support remove()");
    }

    public void set(String name2, Object value) {
        try {
            this.getPropertyUtils().setSimpleProperty(this.instance, name2, value);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error setting property '" + name2 + "' nested exception -" + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error setting property '" + name2 + "', exception - " + t);
        }
    }

    public void set(String name2, int index2, Object value) {
        try {
            this.getPropertyUtils().setIndexedProperty(this.instance, name2, index2, value);
        }
        catch (IndexOutOfBoundsException e2) {
            throw e2;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error setting indexed property '" + name2 + "' nested exception - " + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error setting indexed property '" + name2 + "', exception - " + t);
        }
    }

    public void set(String name2, String key2, Object value) {
        try {
            this.getPropertyUtils().setMappedProperty(this.instance, name2, key2, value);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            throw new IllegalArgumentException("Error setting mapped property '" + name2 + "' nested exception - " + cause);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error setting mapped property '" + name2 + "', exception - " + t);
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    protected DynaProperty getDynaProperty(String name2) {
        DynaProperty descriptor2 = this.getDynaClass().getDynaProperty(name2);
        if (descriptor2 == null) {
            throw new IllegalArgumentException("Invalid property name '" + name2 + "'");
        }
        return descriptor2;
    }

    private PropertyUtilsBean getPropertyUtils() {
        PropertyUtilsBean propUtils = null;
        if (this.dynaClass != null) {
            propUtils = this.dynaClass.getPropertyUtilsBean();
        }
        return propUtils != null ? propUtils : PropertyUtilsBean.getInstance();
    }
}

