/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter
implements Converter {
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils.converters.";
    private transient Log log;
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public <T> T convert(Class<T> type2, Object value) {
        if (type2 == null) {
            return this.convertToDefaultType(type2, value);
        }
        Class<?> sourceType = value == null ? null : value.getClass();
        Class<T> targetType = ConvertUtils.primitiveToWrapper(type2);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Converting" + (value == null ? "" : " '" + this.toString(sourceType) + "'") + " value '" + value + "' to type '" + this.toString(targetType) + "'");
        }
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value.getClass();
        try {
            if (targetType.equals(String.class)) {
                return targetType.cast(this.convertToString(value));
            }
            if (targetType.equals(sourceType)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    No conversion required, value is already a " + this.toString(targetType));
                }
                return targetType.cast(value);
            }
            T result = this.convertToType(targetType, value);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted to " + this.toString(targetType) + " value '" + result + "'");
            }
            return targetType.cast(result);
        }
        catch (Throwable t) {
            return this.handleError(targetType, value, t);
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract <T> T convertToType(Class<T> var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected <T> T handleError(Class<T> type2, Object value, Throwable cause) {
        if (this.log().isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                this.log().debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                this.log().debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type2);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Re-throwing ConversionException: " + cex.getMessage());
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String msg = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type2) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Throwing ConversionException: " + msg);
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
            BeanUtils.initCause(cex, cause);
        }
        throw cex;
    }

    protected <T> T handleMissing(Class<T> type2) {
        if (this.useDefault || type2.equals(String.class)) {
            Object value = this.getDefault(type2);
            if (this.useDefault && value != null && !type2.equals(value.getClass())) {
                try {
                    value = this.convertToType(type2, this.defaultValue);
                }
                catch (Throwable t) {
                    throw new ConversionException("Default conversion to " + this.toString(type2) + " failed.", t);
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default " + (value == null ? "" : this.toString(value.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return type2.cast(value);
        }
        ConversionException cex = new ConversionException("No value specified for '" + this.toString(type2) + "'");
        if (this.log().isDebugEnabled()) {
            this.log().debug("    Throwing ConversionException: " + cex.getMessage());
            this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw cex;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting default value: " + defaultValue);
        }
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class<?> getDefaultType();

    protected Object getDefault(Class<?> type2) {
        if (type2.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    String toString(Class<?> type2) {
        String typeName = null;
        if (type2 == null) {
            typeName = "null";
        } else if (type2.isArray()) {
            Class<?> elementType = type2.getComponentType();
            int count2 = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count2;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count2; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type2.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }

    private <T> T convertToDefaultType(Class<T> targetClass, Object value) {
        Object result = this.convert(this.getDefaultType(), value);
        return (T)result;
    }

    protected ConversionException conversionException(Class<?> type2, Object value) {
        return new ConversionException("Can't convert value '" + value + "' to type " + type2);
    }
}

