/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.list.UnmodifiableList;

public class SequencedHashMap
implements Map,
Cloneable,
Externalizable {
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;
    private transient long modCount = 0L;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;

    private static final Entry createSentinel() {
        Entry s;
        s.prev = s = new Entry(null, null);
        s.next = s;
        return s;
    }

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int initialSize) {
        this.entries = new HashMap(initialSize);
    }

    public SequencedHashMap(int initialSize, float loadFactor) {
        this.entries = new HashMap(initialSize, loadFactor);
    }

    public SequencedHashMap(Map m) {
        this();
        this.putAll(m);
    }

    private void removeEntry(Entry entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private void insertEntry(Entry entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    public boolean containsKey(Object key2) {
        return this.entries.containsKey(key2);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry pos = this.sentinel.next;
            while (pos != this.sentinel) {
                if (pos.getValue() == null) {
                    return true;
                }
                pos = pos.next;
            }
        } else {
            Entry pos = this.sentinel.next;
            while (pos != this.sentinel) {
                if (value.equals(pos.getValue())) {
                    return true;
                }
                pos = pos.next;
            }
        }
        return false;
    }

    public Object get(Object o) {
        Entry entry = (Entry)this.entries.get(o);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getFirst() {
        return this.isEmpty() ? null : this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry getLast() {
        return this.isEmpty() ? null : this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    public Object put(Object key2, Object value) {
        ++this.modCount;
        Object oldValue = null;
        Entry e2 = (Entry)this.entries.get(key2);
        if (e2 != null) {
            this.removeEntry(e2);
            oldValue = e2.setValue(value);
        } else {
            e2 = new Entry(key2, value);
            this.entries.put(key2, e2);
        }
        this.insertEntry(e2);
        return oldValue;
    }

    public Object remove(Object key2) {
        Entry e2 = this.removeImpl(key2);
        return e2 == null ? null : e2.getValue();
    }

    private Entry removeImpl(Object key2) {
        Entry e2 = (Entry)this.entries.remove(key2);
        if (e2 == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(e2);
        return e2;
    }

    public void putAll(Map t) {
        Iterator iter = t.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)obj).entrySet());
    }

    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Entry pos = this.sentinel.next;
        while (pos != this.sentinel) {
            buf.append(pos.getKey());
            buf.append('=');
            buf.append(pos.getValue());
            if (pos.next != this.sentinel) {
                buf.append(',');
            }
            pos = pos.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new OrderedIterator(0);
            }

            public boolean remove(Object o) {
                Entry e2 = SequencedHashMap.this.removeImpl(o);
                return e2 != null;
            }

            public void clear() {
                SequencedHashMap.this.clear();
            }

            public int size() {
                return SequencedHashMap.this.size();
            }

            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            public boolean contains(Object o) {
                return SequencedHashMap.this.containsKey(o);
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new OrderedIterator(1);
            }

            public boolean remove(Object value) {
                if (value == null) {
                    Entry pos = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos != SequencedHashMap.this.sentinel) {
                        if (pos.getValue() == null) {
                            SequencedHashMap.this.removeImpl(pos.getKey());
                            return true;
                        }
                        pos = pos.next;
                    }
                } else {
                    Entry pos = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos != SequencedHashMap.this.sentinel) {
                        if (value.equals(pos.getValue())) {
                            SequencedHashMap.this.removeImpl(pos.getKey());
                            return true;
                        }
                        pos = pos.next;
                    }
                }
                return false;
            }

            public void clear() {
                SequencedHashMap.this.clear();
            }

            public int size() {
                return SequencedHashMap.this.size();
            }

            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            public boolean contains(Object o) {
                return SequencedHashMap.this.containsValue(o);
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            private Entry findEntry(Object o) {
                if (o == null) {
                    return null;
                }
                if (!(o instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry e2 = (Map.Entry)o;
                Entry entry = (Entry)SequencedHashMap.this.entries.get(e2.getKey());
                if (entry != null && entry.equals(e2)) {
                    return entry;
                }
                return null;
            }

            public Iterator iterator() {
                return new OrderedIterator(2);
            }

            public boolean remove(Object o) {
                Entry e2 = this.findEntry(o);
                if (e2 == null) {
                    return false;
                }
                return SequencedHashMap.this.removeImpl(e2.getKey()) != null;
            }

            public void clear() {
                SequencedHashMap.this.clear();
            }

            public int size() {
                return SequencedHashMap.this.size();
            }

            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            public boolean contains(Object o) {
                return this.findEntry(o) != null;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap map2 = (SequencedHashMap)super.clone();
        map2.sentinel = SequencedHashMap.createSentinel();
        map2.entries = new HashMap();
        map2.putAll((Map)this);
        return map2;
    }

    private Map.Entry getEntry(int index2) {
        int i;
        Entry pos = this.sentinel;
        if (index2 < 0) {
            throw new ArrayIndexOutOfBoundsException(index2 + " < 0");
        }
        for (i = -1; i < index2 - 1 && pos.next != this.sentinel; ++i) {
            pos = pos.next;
        }
        if (pos.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(index2 + " >= " + (i + 1));
        }
        return pos.next;
    }

    public Object get(int index2) {
        return this.getEntry(index2).getKey();
    }

    public Object getValue(int index2) {
        return this.getEntry(index2).getValue();
    }

    public int indexOf(Object key2) {
        Entry e2 = (Entry)this.entries.get(key2);
        if (e2 == null) {
            return -1;
        }
        int pos = 0;
        while (e2.prev != this.sentinel) {
            ++pos;
            e2 = e2.prev;
        }
        return pos;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(Object key2) {
        return this.indexOf(key2);
    }

    public List sequence() {
        ArrayList l = new ArrayList(this.size());
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            l.add(iter.next());
        }
        return UnmodifiableList.decorate(l);
    }

    public Object remove(int index2) {
        return this.remove(this.get(index2));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key2 = in.readObject();
            Object value = in.readObject();
            this.put(key2, value);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        Entry pos = this.sentinel.next;
        while (pos != this.sentinel) {
            out.writeObject(pos.getKey());
            out.writeObject(pos.getValue());
            pos = pos.next;
        }
    }

    private class OrderedIterator
    implements Iterator {
        private int returnType;
        private Entry pos;
        private transient long expectedModCount;

        public OrderedIterator(int returnType) {
            this.pos = SequencedHashMap.this.sentinel;
            this.expectedModCount = SequencedHashMap.this.modCount;
            this.returnType = returnType | Integer.MIN_VALUE;
        }

        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.this.sentinel;
        }

        public Object next() {
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.next == SequencedHashMap.this.sentinel) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.this.removeImpl(this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }

    private static class Entry
    implements Map.Entry,
    KeyValue {
        private final Object key;
        private Object value;
        Entry next = null;
        Entry prev = null;

        public Entry(Object key2, Object value) {
            this.key = key2;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }
}

