/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

abstract class AbstractInputCheckedMapDecorator
extends AbstractMapDecorator {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map map2) {
        super(map2);
    }

    protected abstract Object checkSetValue(Object var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    public Set entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    static class MapEntry
    extends AbstractMapEntryDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected MapEntry(Map.Entry entry, AbstractInputCheckedMapDecorator parent) {
            super(entry);
            this.parent = parent;
        }

        public Object setValue(Object value) {
            value = this.parent.checkSetValue(value);
            return this.entry.setValue(value);
        }
    }

    static class EntrySetIterator
    extends AbstractIteratorDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySetIterator(Iterator iterator, AbstractInputCheckedMapDecorator parent) {
            super(iterator);
            this.parent = parent;
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new MapEntry(entry, this.parent);
        }
    }

    static class EntrySet
    extends AbstractSetDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySet(Set set2, AbstractInputCheckedMapDecorator parent) {
            super(set2);
            this.parent = parent;
        }

        public Iterator iterator() {
            return new EntrySetIterator(this.collection.iterator(), this.parent);
        }

        public Object[] toArray() {
            Object[] array2 = this.collection.toArray();
            for (int i = 0; i < array2.length; ++i) {
                array2[i] = new MapEntry((Map.Entry)array2[i], this.parent);
            }
            return array2;
        }

        public Object[] toArray(Object[] array2) {
            Object[] result = array2;
            if (array2.length > 0) {
                result = (Object[])Array.newInstance(array2.getClass().getComponentType(), 0);
            }
            result = this.collection.toArray(result);
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MapEntry((Map.Entry)result[i], this.parent);
            }
            if (result.length > array2.length) {
                return result;
            }
            System.arraycopy(result, 0, array2, 0, result.length);
            if (array2.length > result.length) {
                array2[result.length] = null;
            }
            return array2;
        }
    }
}

