/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.list.AbstractSerializableListDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowthList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = -3620001881672L;

    public static <E> GrowthList<E> growthList(List<E> list) {
        return new GrowthList<E>(list);
    }

    public GrowthList() {
        super(new ArrayList());
    }

    public GrowthList(int initialSize) {
        super(new ArrayList(initialSize));
    }

    protected GrowthList(List<E> list) {
        super(list);
    }

    @Override
    public void add(int index2, E element) {
        int size = this.decorated().size();
        if (index2 > size) {
            this.decorated().addAll(Collections.nCopies(index2 - size, null));
        }
        this.decorated().add(index2, element);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> coll) {
        int size = this.decorated().size();
        boolean result = false;
        if (index2 > size) {
            this.decorated().addAll(Collections.nCopies(index2 - size, null));
            result = true;
        }
        return this.decorated().addAll(index2, coll) | result;
    }

    @Override
    public E set(int index2, E element) {
        int size = this.decorated().size();
        if (index2 >= size) {
            this.decorated().addAll(Collections.nCopies(index2 - size + 1, null));
        }
        return this.decorated().set(index2, element);
    }
}

