/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.set.AbstractSetDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInputCheckedMapDecorator<K, V>
extends AbstractMapDecorator<K, V> {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map<K, V> map2) {
        super(map2);
    }

    protected abstract V checkSetValue(V var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntry
    extends AbstractMapEntryDecorator<K, V> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected MapEntry(Map.Entry<K, V> entry, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(entry);
            this.parent = parent;
        }

        @Override
        public V setValue(V value) {
            value = this.parent.checkSetValue(value);
            return this.getMapEntry().setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    extends AbstractIteratorDecorator<Map.Entry<K, V>> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySetIterator(Iterator<Map.Entry<K, V>> iterator, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = (Map.Entry)this.getIterator().next();
            return new MapEntry(entry, this.parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSetDecorator<Map.Entry<K, V>> {
        private static final long serialVersionUID = 4354731610923110264L;
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySet(Set<Map.Entry<K, V>> set2, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(set2);
            this.parent = parent;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.decorated().iterator(), this.parent);
        }

        @Override
        public Object[] toArray() {
            Object[] array2 = this.decorated().toArray();
            for (int i = 0; i < array2.length; ++i) {
                array2[i] = new MapEntry((Map.Entry)array2[i], this.parent);
            }
            return array2;
        }

        @Override
        public <T> T[] toArray(T[] array2) {
            Object[] result = array2;
            if (array2.length > 0) {
                result = (Object[])Array.newInstance(array2.getClass().getComponentType(), 0);
            }
            result = this.decorated().toArray(result);
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MapEntry((Map.Entry)result[i], this.parent);
            }
            if (result.length > array2.length) {
                return result;
            }
            System.arraycopy(result, 0, array2, 0, result.length);
            if (array2.length > result.length) {
                array2[result.length] = null;
            }
            return array2;
        }
    }
}

