/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractHashedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<K, V>
extends AbstractHashedMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7074655917369299456L;

    public CaseInsensitiveMap() {
        super(16, 0.75f, 12);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> map2) {
        super(map2);
    }

    @Override
    protected Object convertKey(Object key2) {
        if (key2 != null) {
            char[] chars2 = key2.toString().toCharArray();
            for (int i = chars2.length - 1; i >= 0; --i) {
                chars2[i] = Character.toLowerCase(Character.toUpperCase(chars2[i]));
            }
            return new String(chars2);
        }
        return AbstractHashedMap.NULL;
    }

    @Override
    public CaseInsensitiveMap<K, V> clone() {
        return (CaseInsensitiveMap)super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.doWriteObject(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.doReadObject(in);
    }
}

