/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.juli.WebappProperties;

public class ClassLoaderLogManager
extends LogManager {
    private static final boolean isJava9;
    private static ThreadLocal<Boolean> addingLocalRootLogger;
    public static final String DEBUG_PROPERTY;
    protected final Map<ClassLoader, ClassLoaderLogInfo> classLoaderLoggers = new WeakHashMap<ClassLoader, ClassLoaderLogInfo>();
    protected final ThreadLocal<String> prefix = new ThreadLocal();
    protected volatile boolean useShutdownHook = true;

    public ClassLoaderLogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    @Override
    public synchronized boolean addLogger(final Logger logger2) {
        String useParentHandlersString;
        int dotIndex;
        String loggerName = logger2.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        if (info.loggers.containsKey(loggerName)) {
            return false;
        }
        info.loggers.put(loggerName, logger2);
        final String levelString = this.getProperty(loggerName + ".level");
        if (levelString != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        logger2.setLevel(Level.parse(levelString.trim()));
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((dotIndex = loggerName.lastIndexOf(46)) >= 0) {
            String parentName = loggerName.substring(0, dotIndex);
            Logger.getLogger(parentName);
        }
        LogNode node2 = info.rootNode.findNode(loggerName);
        node2.logger = logger2;
        Logger parentLogger = node2.findParentLogger();
        if (parentLogger != null) {
            ClassLoaderLogManager.doSetParentLogger(logger2, parentLogger);
        }
        node2.setParentLogger(logger2);
        String handlers = this.getProperty(loggerName + ".handlers");
        if (handlers != null) {
            logger2.setUseParentHandlers(false);
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                String handlerName = tok.nextToken().trim();
                Handler handler = null;
                for (ClassLoader current = classLoader; current != null && ((info = this.classLoaderLoggers.get(current)) == null || (handler = info.handlers.get(handlerName)) == null); current = current.getParent()) {
                }
                if (handler == null) continue;
                logger2.addHandler(handler);
            }
        }
        if (Boolean.parseBoolean(useParentHandlersString = this.getProperty(loggerName + ".useParentHandlers"))) {
            logger2.setUseParentHandlers(true);
        }
        return true;
    }

    @Override
    public synchronized Logger getLogger(String name2) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.getClassLoaderInfo((ClassLoader)classLoader).loggers.get(name2);
    }

    @Override
    public synchronized Enumeration<String> getLoggerNames() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Collections.enumeration(this.getClassLoaderInfo((ClassLoader)classLoader).loggers.keySet());
    }

    @Override
    public String getProperty(String name2) {
        if (".handlers".equals(name2) && !addingLocalRootLogger.get().booleanValue()) {
            return null;
        }
        String prefix = this.prefix.get();
        String result = null;
        if (prefix != null) {
            result = this.findProperty(prefix + name2);
        }
        if (result == null) {
            result = this.findProperty(name2);
        }
        if (result != null) {
            result = this.replace(result);
        }
        return result;
    }

    private synchronized String findProperty(String name2) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        String result = info.props.getProperty(name2);
        if (result == null && info.props.isEmpty()) {
            for (ClassLoader current = classLoader.getParent(); current != null && ((info = this.classLoaderLoggers.get(current)) == null || (result = info.props.getProperty(name2)) == null && info.props.isEmpty()); current = current.getParent()) {
            }
            if (result == null) {
                result = super.getProperty(name2);
            }
        }
        return result;
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        this.checkAccess();
        this.readConfiguration(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void readConfiguration(InputStream is2) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.readConfiguration(is2, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void reset() throws SecurityException {
        Thread thread2 = Thread.currentThread();
        if (thread2.getClass().getName().startsWith("java.util.logging.LogManager$")) {
            return;
        }
        ClassLoader classLoader = thread2.getContextClassLoader();
        ClassLoaderLogInfo clLogInfo = this.getClassLoaderInfo(classLoader);
        this.resetLoggers(clLogInfo);
    }

    public synchronized void shutdown() {
        for (ClassLoaderLogInfo clLogInfo : this.classLoaderLoggers.values()) {
            this.resetLoggers(clLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLoggers(ClassLoaderLogInfo clLogInfo) {
        ClassLoaderLogInfo classLoaderLogInfo = clLogInfo;
        synchronized (classLoaderLogInfo) {
            for (Logger logger2 : clLogInfo.loggers.values()) {
                Handler[] handlers;
                for (Handler handler : handlers = logger2.getHandlers()) {
                    logger2.removeHandler(handler);
                }
            }
            for (Handler handler : clLogInfo.handlers.values()) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
            clLogInfo.handlers.clear();
        }
    }

    protected synchronized ClassLoaderLogInfo getClassLoaderInfo(ClassLoader classLoader) {
        ClassLoaderLogInfo info;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((info = this.classLoaderLoggers.get(classLoader)) == null) {
            final ClassLoader classLoaderParam = classLoader;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        ClassLoaderLogManager.this.readConfiguration(classLoaderParam);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            info = this.classLoaderLoggers.get(classLoader);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readConfiguration(ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo info;
        InputStream is2;
        block25: {
            is2 = null;
            try {
                if (classLoader instanceof WebappProperties) {
                    if (((WebappProperties)((Object)classLoader)).hasLoggingConfig()) {
                        is2 = classLoader.getResourceAsStream("logging.properties");
                    }
                } else if (classLoader instanceof URLClassLoader) {
                    URL logConfig = ((URLClassLoader)classLoader).findResource("logging.properties");
                    if (null != logConfig) {
                        if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                            System.err.println(this.getClass().getName() + ".readConfiguration(): Found logging.properties at " + logConfig);
                        }
                        is2 = classLoader.getResourceAsStream("logging.properties");
                    } else if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                        System.err.println(this.getClass().getName() + ".readConfiguration(): Found no logging.properties");
                    }
                }
            }
            catch (AccessControlException ace) {
                Logger log;
                info = this.classLoaderLoggers.get(ClassLoader.getSystemClassLoader());
                if (info == null || (log = info.loggers.get("")) == null) break block25;
                Permission perm = ace.getPermission();
                if (perm instanceof FilePermission && perm.getActions().equals("read")) {
                    log.warning("Reading " + perm.getName() + " is not permitted. See \"per context logging\" in the default catalina.policy file.");
                }
                log.warning("Reading logging.properties is not permitted in some context. See \"per context logging\" in the default catalina.policy file.");
                log.warning("Original error was: " + ace.getMessage());
            }
        }
        if (is2 == null && classLoader == ClassLoader.getSystemClassLoader()) {
            String configFileStr = System.getProperty("java.util.logging.config.file");
            if (configFileStr != null) {
                try {
                    is2 = new FileInputStream(this.replace(configFileStr));
                }
                catch (IOException e2) {
                    System.err.println("Configuration error");
                    e2.printStackTrace();
                }
            }
            if (is2 == null) {
                File defaultFile = new File(new File(System.getProperty("java.home"), isJava9 ? "conf" : "lib"), "logging.properties");
                try {
                    is2 = new FileInputStream(defaultFile);
                }
                catch (IOException e3) {
                    System.err.println("Configuration error");
                    e3.printStackTrace();
                }
            }
        }
        RootLogger localRootLogger = new RootLogger();
        if (is2 == null) {
            ClassLoaderLogInfo info2 = null;
            for (ClassLoader current = classLoader.getParent(); current != null && info2 == null; current = current.getParent()) {
                info2 = this.getClassLoaderInfo(current);
            }
            if (info2 != null) {
                localRootLogger.setParent(info2.rootNode.logger);
            }
        }
        info = new ClassLoaderLogInfo(new LogNode(null, localRootLogger));
        this.classLoaderLoggers.put(classLoader, info);
        if (is2 != null) {
            this.readConfiguration(is2, classLoader);
        }
        try {
            addingLocalRootLogger.set(Boolean.TRUE);
            this.addLogger(localRootLogger);
        }
        finally {
            addingLocalRootLogger.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readConfiguration(InputStream is2, ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo info = this.classLoaderLoggers.get(classLoader);
        try {
            info.props.load(is2);
        }
        catch (IOException e2) {
            System.err.println("Configuration error");
            e2.printStackTrace();
        }
        finally {
            try {
                is2.close();
            }
            catch (IOException e2) {}
        }
        String rootHandlers = info.props.getProperty(".handlers");
        String handlers = info.props.getProperty("handlers");
        Logger localRootLogger = info.rootNode.logger;
        if (handlers != null) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                int pos;
                String handlerName;
                String handlerClassName = handlerName = tok.nextToken().trim();
                String prefix = "";
                if (handlerClassName.length() <= 0) continue;
                if (Character.isDigit(handlerClassName.charAt(0)) && (pos = handlerClassName.indexOf(46)) >= 0) {
                    prefix = handlerClassName.substring(0, pos + 1);
                    handlerClassName = handlerClassName.substring(pos + 1);
                }
                try {
                    this.prefix.set(prefix);
                    Handler handler = (Handler)classLoader.loadClass(handlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.prefix.set(null);
                    info.handlers.put(handlerName, handler);
                    if (rootHandlers != null) continue;
                    localRootLogger.addHandler(handler);
                }
                catch (Exception e3) {
                    System.err.println("Handler error");
                    e3.printStackTrace();
                }
            }
        }
    }

    protected static void doSetParentLogger(final Logger logger2, final Logger parent) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                logger2.setParent(parent);
                return null;
            }
        });
    }

    protected String replace(String str2) {
        String result = str2;
        int pos_start = str2.indexOf("${");
        if (pos_start >= 0) {
            StringBuilder builder = new StringBuilder();
            int pos_end = -1;
            while (pos_start >= 0) {
                builder.append(str2, pos_end + 1, pos_start);
                pos_end = str2.indexOf(125, pos_start + 2);
                if (pos_end < 0) {
                    pos_end = pos_start - 1;
                    break;
                }
                String propName = str2.substring(pos_start + 2, pos_end);
                String replacement = this.replaceWebApplicationProperties(propName);
                if (replacement == null) {
                    String string2 = replacement = propName.length() > 0 ? System.getProperty(propName) : null;
                }
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str2, pos_start, pos_end + 1);
                }
                pos_start = str2.indexOf("${", pos_end + 1);
            }
            builder.append(str2, pos_end + 1, str2.length());
            result = builder.toString();
        }
        return result;
    }

    private String replaceWebApplicationProperties(String propName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof WebappProperties) {
            WebappProperties wProps = (WebappProperties)((Object)cl);
            if ("classloader.webappName".equals(propName)) {
                return wProps.getWebappName();
            }
            if ("classloader.hostName".equals(propName)) {
                return wProps.getHostName();
            }
            if ("classloader.serviceName".equals(propName)) {
                return wProps.getServiceName();
            }
            return null;
        }
        return null;
    }

    static {
        addingLocalRootLogger = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        DEBUG_PROPERTY = ClassLoaderLogManager.class.getName() + ".debug";
        Class<?> c = null;
        try {
            c = Class.forName("java.lang.Runtime$Version");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isJava9 = c != null;
    }

    protected static class RootLogger
    extends Logger {
        public RootLogger() {
            super("", null);
        }
    }

    protected static final class ClassLoaderLogInfo {
        final LogNode rootNode;
        final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
        final Map<String, Handler> handlers = new HashMap<String, Handler>();
        final Properties props = new Properties();

        ClassLoaderLogInfo(LogNode rootNode) {
            this.rootNode = rootNode;
        }
    }

    protected static final class LogNode {
        Logger logger;
        final Map<String, LogNode> children = new HashMap<String, LogNode>();
        final LogNode parent;

        LogNode(LogNode parent, Logger logger2) {
            this.parent = parent;
            this.logger = logger2;
        }

        LogNode(LogNode parent) {
            this(parent, null);
        }

        LogNode findNode(String name2) {
            LogNode currentNode = this;
            if (this.logger.getName().equals(name2)) {
                return this;
            }
            while (name2 != null) {
                String nextName;
                int dotIndex = name2.indexOf(46);
                if (dotIndex < 0) {
                    nextName = name2;
                    name2 = null;
                } else {
                    nextName = name2.substring(0, dotIndex);
                    name2 = name2.substring(dotIndex + 1);
                }
                LogNode childNode = currentNode.children.get(nextName);
                if (childNode == null) {
                    childNode = new LogNode(currentNode);
                    currentNode.children.put(nextName, childNode);
                }
                currentNode = childNode;
            }
            return currentNode;
        }

        Logger findParentLogger() {
            Logger logger2 = null;
            LogNode node2 = this.parent;
            while (node2 != null && logger2 == null) {
                logger2 = node2.logger;
                node2 = node2.parent;
            }
            return logger2;
        }

        void setParentLogger(Logger parent) {
            for (LogNode childNode : this.children.values()) {
                if (childNode.logger == null) {
                    childNode.setParentLogger(parent);
                    continue;
                }
                ClassLoaderLogManager.doSetParentLogger(childNode.logger, parent);
            }
        }
    }

    private final class Cleaner
    extends Thread {
        private Cleaner() {
        }

        @Override
        public void run() {
            if (ClassLoaderLogManager.this.useShutdownHook) {
                ClassLoaderLogManager.this.shutdown();
            }
        }
    }
}

