/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.codec;

import java.io.IOException;

public class H64 {
    private static final char[] itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    private static short toShort(byte b) {
        return (short)(b & 0xFF);
    }

    private static int toInt(byte[] bytes2, int offset, int numBytes) {
        if (numBytes < 1 || numBytes > 4) {
            throw new IllegalArgumentException("numBytes must be between 1 and 4.");
        }
        int val2 = H64.toShort(bytes2[offset]);
        block5: for (int i = 1; i < numBytes; ++i) {
            short s = H64.toShort(bytes2[offset + i]);
            switch (i) {
                case 1: {
                    val2 |= s << 8;
                    continue block5;
                }
                case 2: {
                    val2 |= s << 16;
                    continue block5;
                }
                case 3: {
                    val2 |= s << 24;
                }
            }
        }
        return val2;
    }

    private static void append(Appendable buf, char c) {
        try {
            buf.append(c);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unable to append character to internal buffer.", e2);
        }
    }

    private static void encodeAndAppend(int value, Appendable buf, int numChars) {
        for (int i = 0; i < numChars; ++i) {
            H64.append(buf, itoa64[value & 0x3F]);
            value >>= 6;
        }
    }

    public static String encodeToString(byte[] bytes2) {
        int i;
        if (bytes2 == null || bytes2.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int length = bytes2.length;
        int remainder = length % 3;
        int last3ByteIndex = length - remainder;
        for (i = 0; i < last3ByteIndex; i += 3) {
            int twentyFourBit = H64.toInt(bytes2, i, 3);
            H64.encodeAndAppend(twentyFourBit, buf, 4);
        }
        if (remainder > 0) {
            int a = H64.toInt(bytes2, i, remainder);
            H64.encodeAndAppend(a, buf, remainder + 1);
        }
        return buf.toString();
    }
}

