/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.UnresolveableReferenceException;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.Factory;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.Nameable;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ReflectionBuilder.class);
    private static final String OBJECT_REFERENCE_BEGIN_TOKEN = "$";
    private static final String ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN = "\\$";
    private static final String GLOBAL_PROPERTY_PREFIX = "shiro";
    private static final char MAP_KEY_VALUE_DELIMITER = ':';
    private static final String HEX_BEGIN_TOKEN = "0x";
    private static final String NULL_VALUE_TOKEN = "null";
    private static final String EMPTY_STRING_VALUE_TOKEN = "\"\"";
    private static final char STRING_VALUE_DELIMETER = '\"';
    private static final char MAP_PROPERTY_BEGIN_TOKEN = '[';
    private static final char MAP_PROPERTY_END_TOKEN = ']';
    private Map<String, ?> objects;

    public ReflectionBuilder() {
        this.objects = new LinkedHashMap();
    }

    public ReflectionBuilder(Map<String, ?> defaults) {
        this.objects = CollectionUtils.isEmpty(defaults) ? new LinkedHashMap() : defaults;
    }

    public Map<String, ?> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, ?> objects) {
        this.objects = CollectionUtils.isEmpty(objects) ? new LinkedHashMap() : objects;
    }

    public Object getBean(String id) {
        return this.objects.get(id);
    }

    public <T> T getBean(String id, Class<T> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType argument cannot be null.");
        }
        Object bean2 = this.getBean(id);
        if (bean2 == null) {
            return null;
        }
        if (!requiredType.isAssignableFrom(bean2.getClass())) {
            throw new IllegalStateException("Bean with id [" + id + "] is not of the required type [" + requiredType.getName() + "].");
        }
        return (T)bean2;
    }

    public Map<String, ?> buildObjects(Map<String, String> kvPairs) {
        if (kvPairs != null && !kvPairs.isEmpty()) {
            LinkedHashMap<String, String> instanceMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : kvPairs.entrySet()) {
                if (entry.getKey().indexOf(46) < 0 || entry.getKey().endsWith(".class")) {
                    instanceMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                propertyMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : instanceMap.entrySet()) {
                this.createNewInstance(this.objects, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                this.applyProperty(entry.getKey(), entry.getValue(), this.objects);
            }
        }
        LifecycleUtils.init(this.objects.values());
        return this.objects;
    }

    protected void createNewInstance(Map<String, Object> objects, String name2, String value) {
        Object instance;
        Object currentInstance = objects.get(name2);
        if (currentInstance != null) {
            log.info("An instance with name '{}' already exists.  Redefining this object as a new instance of type {}", (Object)name2, (Object)value);
        }
        try {
            instance = ClassUtils.newInstance(value);
            if (instance instanceof Nameable) {
                ((Nameable)instance).setName(name2);
            }
        }
        catch (Exception e2) {
            String msg = "Unable to instantiate class [" + value + "] for object named '" + name2 + "'.  " + "Please ensure you've specified the fully qualified class name correctly.";
            throw new ConfigurationException(msg, e2);
        }
        objects.put(name2, instance);
    }

    protected void applyProperty(String key2, String value, Map objects) {
        int index2 = key2.indexOf(46);
        if (index2 >= 0) {
            String name2 = key2.substring(0, index2);
            String property = key2.substring(index2 + 1, key2.length());
            if (GLOBAL_PROPERTY_PREFIX.equalsIgnoreCase(name2)) {
                this.applyGlobalProperty(objects, property, value);
            } else {
                this.applySingleProperty(objects, name2, property, value);
            }
        } else {
            throw new IllegalArgumentException("All property keys must contain a '.' character. (e.g. myBean.property = value)  These should already be separated out by buildObjects().");
        }
    }

    protected void applyGlobalProperty(Map objects, String property, String value) {
        for (Object instance : objects.values()) {
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(instance, property);
                if (pd == null) continue;
                this.applyProperty(instance, property, value);
            }
            catch (Exception e2) {
                String msg = "Error retrieving property descriptor for instance of type [" + instance.getClass().getName() + "] " + "while setting property [" + property + "]";
                throw new ConfigurationException(msg, e2);
            }
        }
    }

    protected void applySingleProperty(Map objects, String name2, String property, String value) {
        Object instance = objects.get(name2);
        if (property.equals("class")) {
            throw new IllegalArgumentException("Property keys should not contain 'class' properties since these should already be separated out by buildObjects().");
        }
        if (instance == null) {
            String msg = "Configuration error.  Specified object [" + name2 + "] with property [" + property + "] without first defining that object's class.  Please first " + "specify the class property first, e.g. myObject = fully_qualified_class_name " + "and then define additional properties.";
            throw new IllegalArgumentException(msg);
        }
        this.applyProperty(instance, property, value);
    }

    protected boolean isReference(String value) {
        return value != null && value.startsWith(OBJECT_REFERENCE_BEGIN_TOKEN);
    }

    protected String getId(String referenceToken) {
        return referenceToken.substring(OBJECT_REFERENCE_BEGIN_TOKEN.length());
    }

    protected Object getReferencedObject(String id) {
        Object o;
        Object v0 = o = this.objects != null && !this.objects.isEmpty() ? this.objects.get(id) : null;
        if (o == null) {
            String msg = "The object with id [" + id + "] has not yet been defined and therefore cannot be " + "referenced.  Please ensure objects are defined in the order in which they should be " + "created and made available for future reference.";
            throw new UnresolveableReferenceException(msg);
        }
        return o;
    }

    protected String unescapeIfNecessary(String value) {
        if (value != null && value.startsWith(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN)) {
            return value.substring(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN.length() - 1);
        }
        return value;
    }

    protected Object resolveReference(String reference) {
        String id = this.getId(reference);
        log.debug("Encountered object reference '{}'.  Looking up object with id '{}'", (Object)reference, (Object)id);
        Object referencedObject = this.getReferencedObject(id);
        if (referencedObject instanceof Factory) {
            return ((Factory)referencedObject).getInstance();
        }
        return referencedObject;
    }

    protected boolean isTypedProperty(Object object, String propertyName, Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("type (class) argument cannot be null.");
        }
        try {
            PropertyDescriptor descriptor2 = PropertyUtils.getPropertyDescriptor(object, propertyName);
            if (descriptor2 == null) {
                String msg = "Property '" + propertyName + "' does not exist for object of " + "type " + object.getClass().getName() + ".";
                throw new ConfigurationException(msg);
            }
            Class<?> propertyClazz = descriptor2.getPropertyType();
            return clazz.isAssignableFrom(propertyClazz);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e2) {
            String msg = "Unable to determine if property [" + propertyName + "] represents a " + clazz.getName();
            throw new ConfigurationException(msg, e2);
        }
    }

    protected Set<?> toSet(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Set) {
            return (Set)reference;
        }
        LinkedHashSet<String> setTokens = new LinkedHashSet<String>(Arrays.asList(tokens));
        LinkedHashSet<Object> values = new LinkedHashSet<Object>(setTokens.size());
        for (String token : setTokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected Map<?, ?> toMap(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue, ',', '\"', '\"', true, true);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Map) {
            return (Map)reference;
        }
        LinkedHashMap<String, String> mapTokens = new LinkedHashMap<String, String>(tokens.length);
        for (String token : tokens) {
            String[] kvPair = StringUtils.split(token, ':');
            if (kvPair == null || kvPair.length != 2) {
                String msg = "Map property value [" + sValue + "] contained key-value pair token [" + token + "] that does not properly split to a single key and pair.  This must be the " + "case for all map entries.";
                throw new ConfigurationException(msg);
            }
            mapTokens.put(kvPair[0], kvPair[1]);
        }
        LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>(mapTokens.size());
        for (Map.Entry entry : mapTokens.entrySet()) {
            Object key2 = this.resolveValue((String)entry.getKey());
            Object value = this.resolveValue((String)entry.getValue());
            map2.put(key2, value);
        }
        return map2;
    }

    private Collection<?> toCollection(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Collection) {
            return (Collection)reference;
        }
        ArrayList<Object> values = new ArrayList<Object>(tokens.length);
        for (String token : tokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected List<?> toList(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof List) {
            return (List)reference;
        }
        ArrayList<Object> values = new ArrayList<Object>(tokens.length);
        for (String token : tokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected byte[] toBytes(String sValue) {
        byte[] bytes2;
        if (sValue == null) {
            return null;
        }
        if (sValue.startsWith(HEX_BEGIN_TOKEN)) {
            String hex = sValue.substring(HEX_BEGIN_TOKEN.length());
            bytes2 = Hex.decode(hex);
        } else {
            bytes2 = Base64.decode(sValue);
        }
        return bytes2;
    }

    protected Object resolveValue(String stringValue) {
        Object value = this.isReference(stringValue) ? this.resolveReference(stringValue) : this.unescapeIfNecessary(stringValue);
        return value;
    }

    protected String checkForNullOrEmptyLiteral(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (stringValue.equals("\"null\"")) {
            return NULL_VALUE_TOKEN;
        }
        if (stringValue.equals("\"\"\"\"")) {
            return EMPTY_STRING_VALUE_TOKEN;
        }
        return stringValue;
    }

    protected void applyProperty(Object object, String propertyPath, Object value) {
        int mapBegin = propertyPath.indexOf(91);
        int mapEnd = -1;
        String mapPropertyPath = null;
        String keyString = null;
        String remaining = null;
        if (mapBegin >= 0) {
            mapPropertyPath = propertyPath.substring(0, mapBegin);
            mapEnd = propertyPath.indexOf(93, mapBegin);
            keyString = propertyPath.substring(mapBegin + 1, mapEnd);
            if (propertyPath.length() > mapEnd + 1 && (remaining = propertyPath.substring(mapEnd + 1)).startsWith(".")) {
                remaining = StringUtils.clean(remaining.substring(1));
            }
        }
        if (remaining == null) {
            if (keyString == null) {
                this.setProperty(object, propertyPath, value);
            } else if (this.isTypedProperty(object, mapPropertyPath, Map.class)) {
                Map map2 = (Map)this.getProperty(object, mapPropertyPath);
                Object mapKey = this.resolveValue(keyString);
                map2.put(mapKey, value);
            } else {
                int index2 = Integer.valueOf(keyString);
                this.setIndexedProperty(object, mapPropertyPath, index2, value);
            }
        } else {
            Object referencedValue = null;
            if (this.isTypedProperty(object, mapPropertyPath, Map.class)) {
                Map map3 = (Map)this.getProperty(object, mapPropertyPath);
                Object mapKey = this.resolveValue(keyString);
                referencedValue = map3.get(mapKey);
            } else {
                int index3 = Integer.valueOf(keyString);
                referencedValue = this.getIndexedProperty(object, mapPropertyPath, index3);
            }
            if (referencedValue == null) {
                throw new ConfigurationException("Referenced map/array value '" + mapPropertyPath + "[" + keyString + "]' does not exist.");
            }
            this.applyProperty(referencedValue, remaining, value);
        }
    }

    private void setProperty(Object object, String propertyPath, Object value) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Applying property [{}] value [{}] on object of type [{}]", new Object[]{propertyPath, value, object.getClass().getName()});
            }
            BeanUtils.setProperty(object, propertyPath, value);
        }
        catch (Exception e2) {
            String msg = "Unable to set property '" + propertyPath + "' with value [" + value + "] on object " + "of type " + (object != null ? object.getClass().getName() : null) + ".  If " + "'" + value + "' is a reference to another (previously defined) object, prefix it with " + "'" + OBJECT_REFERENCE_BEGIN_TOKEN + "' to indicate that the referenced " + "object should be used as the actual value.  " + "For example, " + OBJECT_REFERENCE_BEGIN_TOKEN + value;
            throw new ConfigurationException(msg, e2);
        }
    }

    private Object getProperty(Object object, String propertyPath) {
        try {
            return PropertyUtils.getProperty(object, propertyPath);
        }
        catch (Exception e2) {
            throw new ConfigurationException("Unable to access property '" + propertyPath + "'", e2);
        }
    }

    private void setIndexedProperty(Object object, String propertyPath, int index2, Object value) {
        try {
            PropertyUtils.setIndexedProperty(object, propertyPath, index2, value);
        }
        catch (Exception e2) {
            throw new ConfigurationException("Unable to set array property '" + propertyPath + "'", e2);
        }
    }

    private Object getIndexedProperty(Object object, String propertyPath, int index2) {
        try {
            return PropertyUtils.getIndexedProperty(object, propertyPath, index2);
        }
        catch (Exception e2) {
            throw new ConfigurationException("Unable to acquire array property '" + propertyPath + "'", e2);
        }
    }

    protected boolean isIndexedPropertyAssignment(String propertyPath) {
        return propertyPath.endsWith("]");
    }

    protected void applyProperty(Object object, String propertyName, String stringValue) {
        Object value;
        if (NULL_VALUE_TOKEN.equals(stringValue)) {
            value = null;
        } else if (EMPTY_STRING_VALUE_TOKEN.equals(stringValue)) {
            value = "";
        } else if (this.isIndexedPropertyAssignment(propertyName)) {
            String checked = this.checkForNullOrEmptyLiteral(stringValue);
            value = this.resolveValue(checked);
        } else if (this.isTypedProperty(object, propertyName, Set.class)) {
            value = this.toSet(stringValue);
        } else if (this.isTypedProperty(object, propertyName, Map.class)) {
            value = this.toMap(stringValue);
        } else if (this.isTypedProperty(object, propertyName, List.class)) {
            value = this.toList(stringValue);
        } else if (this.isTypedProperty(object, propertyName, Collection.class)) {
            value = this.toCollection(stringValue);
        } else if (this.isTypedProperty(object, propertyName, byte[].class)) {
            value = this.toBytes(stringValue);
        } else if (this.isTypedProperty(object, propertyName, ByteSource.class)) {
            byte[] bytes2 = this.toBytes(stringValue);
            value = ByteSource.Util.bytes(bytes2);
        } else {
            String checked = this.checkForNullOrEmptyLiteral(stringValue);
            value = this.resolveValue(checked);
        }
        this.applyProperty(object, propertyName, value);
    }
}

