/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.env;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.env.NamedObjectEnvironment;
import org.apache.shiro.env.RequiredTypeException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.LifecycleUtils;

public class DefaultEnvironment
implements NamedObjectEnvironment,
Destroyable {
    public static final String DEFAULT_SECURITY_MANAGER_KEY = "securityManager";
    protected final Map<String, Object> objects;
    private String securityManagerName = "securityManager";

    public DefaultEnvironment() {
        this(new ConcurrentHashMap());
    }

    public DefaultEnvironment(Map<String, ?> seed) {
        if (seed == null) {
            throw new IllegalArgumentException("Backing map cannot be null.");
        }
        this.objects = seed;
    }

    @Override
    public SecurityManager getSecurityManager() throws IllegalStateException {
        SecurityManager securityManager = this.lookupSecurityManager();
        if (securityManager == null) {
            throw new IllegalStateException("No SecurityManager found in Environment.  This is an invalid environment state.");
        }
        return securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (securityManager == null) {
            throw new IllegalArgumentException("Null SecurityManager instances are not allowed.");
        }
        String name2 = this.getSecurityManagerName();
        this.setObject(name2, securityManager);
    }

    protected SecurityManager lookupSecurityManager() {
        String name2 = this.getSecurityManagerName();
        return this.getObject(name2, SecurityManager.class);
    }

    public String getSecurityManagerName() {
        return this.securityManagerName;
    }

    public void setSecurityManagerName(String securityManagerName) {
        this.securityManagerName = securityManagerName;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    @Override
    public <T> T getObject(String name2, Class<T> requiredType) throws RequiredTypeException {
        if (name2 == null) {
            throw new NullPointerException("name parameter cannot be null.");
        }
        if (requiredType == null) {
            throw new NullPointerException("requiredType parameter cannot be null.");
        }
        Object o = this.objects.get(name2);
        if (o == null) {
            return null;
        }
        if (!requiredType.isInstance(o)) {
            String msg = "Object named '" + name2 + "' is not of required type [" + requiredType.getName() + "].";
            throw new RequiredTypeException(msg);
        }
        return (T)o;
    }

    public void setObject(String name2, Object instance) {
        if (name2 == null) {
            throw new NullPointerException("name parameter cannot be null.");
        }
        if (instance == null) {
            this.objects.remove(name2);
        } else {
            this.objects.put(name2, instance);
        }
    }

    @Override
    public void destroy() throws Exception {
        LifecycleUtils.destroy(this.objects.values());
    }
}

