/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.shiro.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String URL_PREFIX = "url:";
    public static final String FILE_PREFIX = "file:";
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static boolean hasResourcePrefix(String resourcePath) {
        return resourcePath != null && (resourcePath.startsWith(CLASSPATH_PREFIX) || resourcePath.startsWith(URL_PREFIX) || resourcePath.startsWith(FILE_PREFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceExists(String resourcePath) {
        InputStream stream = null;
        boolean exists = false;
        try {
            stream = ResourceUtils.getInputStreamForPath(resourcePath);
            exists = true;
        }
        catch (IOException e2) {
            stream = null;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return exists;
    }

    public static InputStream getInputStreamForPath(String resourcePath) throws IOException {
        InputStream is2 = resourcePath.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.loadFromClassPath(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(URL_PREFIX) ? ResourceUtils.loadFromUrl(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(FILE_PREFIX) ? ResourceUtils.loadFromFile(ResourceUtils.stripPrefix(resourcePath)) : ResourceUtils.loadFromFile(resourcePath)));
        if (is2 == null) {
            throw new IOException("Resource [" + resourcePath + "] could not be found.");
        }
        return is2;
    }

    private static InputStream loadFromFile(String path2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Opening file [" + path2 + "]...");
        }
        return new FileInputStream(path2);
    }

    private static InputStream loadFromUrl(String urlPath) throws IOException {
        log.debug("Opening url {}", (Object)urlPath);
        URL url = new URL(urlPath);
        return url.openStream();
    }

    private static InputStream loadFromClassPath(String path2) {
        log.debug("Opening resource from class path [{}]", (Object)path2);
        return ClassUtils.getResourceAsStream(path2);
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    public static void close(InputStream is2) {
        if (is2 != null) {
            try {
                is2.close();
            }
            catch (IOException e2) {
                log.warn("Error closing input stream.", e2);
            }
        }
    }
}

