/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.codec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.shiro.lang.codec.CodecException;
import org.apache.shiro.lang.util.ByteSource;

public abstract class CodecSupport {
    public static final String PREFERRED_ENCODING = "UTF-8";

    public static byte[] toBytes(char[] chars2) {
        return CodecSupport.toBytes(new String(chars2), PREFERRED_ENCODING);
    }

    public static byte[] toBytes(char[] chars2, String encoding2) throws CodecException {
        return CodecSupport.toBytes(new String(chars2), encoding2);
    }

    public static byte[] toBytes(String source2) {
        return CodecSupport.toBytes(source2, PREFERRED_ENCODING);
    }

    public static byte[] toBytes(String source2, String encoding2) throws CodecException {
        try {
            return source2.getBytes(encoding2);
        }
        catch (UnsupportedEncodingException e2) {
            String msg = "Unable to convert source [" + source2 + "] to byte array using encoding '" + encoding2 + "'";
            throw new CodecException(msg, e2);
        }
    }

    public static String toString(byte[] bytes2) {
        return CodecSupport.toString(bytes2, PREFERRED_ENCODING);
    }

    public static String toString(byte[] bytes2, String encoding2) throws CodecException {
        try {
            return new String(bytes2, encoding2);
        }
        catch (UnsupportedEncodingException e2) {
            String msg = "Unable to convert byte array to String with encoding '" + encoding2 + "'.";
            throw new CodecException(msg, e2);
        }
    }

    public static char[] toChars(byte[] bytes2) {
        return CodecSupport.toChars(bytes2, PREFERRED_ENCODING);
    }

    public static char[] toChars(byte[] bytes2, String encoding2) throws CodecException {
        return CodecSupport.toString(bytes2, encoding2).toCharArray();
    }

    protected boolean isByteSource(Object o) {
        return o instanceof byte[] || o instanceof char[] || o instanceof String || o instanceof ByteSource || o instanceof File || o instanceof InputStream;
    }

    protected byte[] toBytes(Object object) {
        if (object == null) {
            String msg = "Argument for byte conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof ByteSource) {
            return ((ByteSource)object).getBytes();
        }
        if (object instanceof char[]) {
            return CodecSupport.toBytes((char[])object);
        }
        if (object instanceof String) {
            return CodecSupport.toBytes((String)object);
        }
        if (object instanceof File) {
            return this.toBytes((File)object);
        }
        if (object instanceof InputStream) {
            return this.toBytes((InputStream)object);
        }
        return this.objectToBytes(object);
    }

    protected String toString(Object o) {
        if (o == null) {
            String msg = "Argument for String conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof byte[]) {
            return CodecSupport.toString((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return this.objectToString(o);
    }

    protected byte[] toBytes(File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        try {
            return this.toBytes(new FileInputStream(file2));
        }
        catch (FileNotFoundException e2) {
            String msg = "Unable to acquire InputStream for file [" + file2 + "]";
            throw new CodecException(msg, e2);
        }
    }

    protected byte[] toBytes(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream argument cannot be null.");
        }
        int BUFFER_SIZE = 512;
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        byte[] buffer = new byte[512];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new CodecException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected byte[] objectToBytes(Object o) {
        String msg = "The " + this.getClass().getName() + " implementation only supports conversion to byte[] if the source is of type byte[], char[], String, " + ByteSource.class.getName() + " File or InputStream.  The instance provided as a method argument is of type [" + o.getClass().getName() + "].  If you would like to convert this argument type to a byte[], you can 1) convert the argument to one of the supported types yourself and then use that as the method argument or 2) subclass " + this.getClass().getName() + "and override the objectToBytes(Object o) method.";
        throw new CodecException(msg);
    }

    protected String objectToString(Object o) {
        return o.toString();
    }
}

