/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.NativeSessionManager;
import org.apache.shiro.session.mgt.SessionKey;

public class DelegatingSession
implements Session,
Serializable {
    private final SessionKey key;
    private Date startTimestamp = null;
    private String host = null;
    private final transient NativeSessionManager sessionManager;

    public DelegatingSession(NativeSessionManager sessionManager, SessionKey key2) {
        if (sessionManager == null) {
            throw new IllegalArgumentException("sessionManager argument cannot be null.");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("sessionKey argument cannot be null.");
        }
        if (key2.getSessionId() == null) {
            String msg = "The " + DelegatingSession.class.getName() + " implementation requires that the " + "SessionKey argument returns a non-null sessionId to support the " + "Session.getId() invocations.";
            throw new IllegalArgumentException(msg);
        }
        this.sessionManager = sessionManager;
        this.key = key2;
    }

    @Override
    public Serializable getId() {
        return this.key.getSessionId();
    }

    @Override
    public Date getStartTimestamp() {
        if (this.startTimestamp == null) {
            this.startTimestamp = this.sessionManager.getStartTimestamp(this.key);
        }
        return this.startTimestamp;
    }

    @Override
    public Date getLastAccessTime() {
        return this.sessionManager.getLastAccessTime(this.key);
    }

    @Override
    public long getTimeout() throws InvalidSessionException {
        return this.sessionManager.getTimeout(this.key);
    }

    @Override
    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        this.sessionManager.setTimeout(this.key, maxIdleTimeInMillis);
    }

    @Override
    public String getHost() {
        if (this.host == null) {
            this.host = this.sessionManager.getHost(this.key);
        }
        return this.host;
    }

    @Override
    public void touch() throws InvalidSessionException {
        this.sessionManager.touch(this.key);
    }

    @Override
    public void stop() throws InvalidSessionException {
        this.sessionManager.stop(this.key);
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        return this.sessionManager.getAttributeKeys(this.key);
    }

    @Override
    public Object getAttribute(Object attributeKey) throws InvalidSessionException {
        return this.sessionManager.getAttribute(this.key, attributeKey);
    }

    @Override
    public void setAttribute(Object attributeKey, Object value) throws InvalidSessionException {
        if (value == null) {
            this.removeAttribute(attributeKey);
        } else {
            this.sessionManager.setAttribute(this.key, attributeKey, value);
        }
    }

    @Override
    public Object removeAttribute(Object attributeKey) throws InvalidSessionException {
        return this.sessionManager.removeAttribute(this.key, attributeKey);
    }
}

