/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.io.File;
import java.io.InputStream;
import org.apache.shiro.util.SimpleByteSource;

public interface ByteSource {
    public byte[] getBytes();

    public String toHex();

    public String toBase64();

    public boolean isEmpty();

    public static final class Util {
        public static ByteSource bytes(byte[] bytes2) {
            return new SimpleByteSource(bytes2);
        }

        public static ByteSource bytes(char[] chars2) {
            return new SimpleByteSource(chars2);
        }

        public static ByteSource bytes(String string2) {
            return new SimpleByteSource(string2);
        }

        public static ByteSource bytes(ByteSource source2) {
            return new SimpleByteSource(source2);
        }

        public static ByteSource bytes(File file2) {
            return new SimpleByteSource(file2);
        }

        public static ByteSource bytes(InputStream stream) {
            return new SimpleByteSource(stream);
        }

        public static boolean isCompatible(Object source2) {
            return SimpleByteSource.isCompatible(source2);
        }

        public static ByteSource bytes(Object source2) throws IllegalArgumentException {
            if (source2 == null) {
                return null;
            }
            if (!Util.isCompatible(source2)) {
                String msg = "Unable to heuristically acquire bytes for object of type [" + source2.getClass().getName() + "].  If this type is indeed a byte-backed data type, you might " + "want to write your own ByteSource implementation to extract its bytes explicitly.";
                throw new IllegalArgumentException(msg);
            }
            if (source2 instanceof byte[]) {
                return Util.bytes((byte[])source2);
            }
            if (source2 instanceof ByteSource) {
                return (ByteSource)source2;
            }
            if (source2 instanceof char[]) {
                return Util.bytes((char[])source2);
            }
            if (source2 instanceof String) {
                return Util.bytes((String)source2);
            }
            if (source2 instanceof File) {
                return Util.bytes((File)source2);
            }
            if (source2 instanceof InputStream) {
                return Util.bytes((InputStream)source2);
            }
            throw new IllegalStateException("Encountered unexpected byte source.  This is a bug - please notify the Shiro developer list asap (the isCompatible implementation does not reflect this method's implementation).");
        }
    }
}

