/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;

public class MapContext
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 5373399119017820322L;
    private final Map<String, Object> backingMap = new HashMap<String, Object>();

    public MapContext() {
    }

    public MapContext(Map<String, Object> map2) {
        this();
        if (!CollectionUtils.isEmpty(map2)) {
            this.backingMap.putAll(map2);
        }
    }

    protected <E> E getTypedValue(String key2, Class<E> type2) {
        Object found = null;
        Object o = this.backingMap.get(key2);
        if (o != null) {
            if (!type2.isAssignableFrom(o.getClass())) {
                String msg = "Invalid object found in SubjectContext Map under key [" + key2 + "].  Expected type " + "was [" + type2.getName() + "], but the object under that key is of type " + "[" + o.getClass().getName() + "].";
                throw new IllegalArgumentException(msg);
            }
            found = o;
        }
        return (E)found;
    }

    protected void nullSafePut(String key2, Object value) {
        if (value != null) {
            this.put(key2, value);
        }
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.backingMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.backingMap.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.backingMap.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        return this.backingMap.put(s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.backingMap.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ?> map2) {
        this.backingMap.putAll(map2);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.backingMap.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.backingMap.entrySet());
    }
}

