/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    @Override
    public void begin(String namespace2, String theName, Attributes attributes) throws Exception {
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            if (top != null) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " properties");
            } else {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name2 = attributes.getLocalName(i);
            if ("".equals(name2)) {
                name2 = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + name2 + "' to '" + value + "'");
            }
            if (this.digester.isFakeAttribute(top, name2) || IntrospectionUtils.setProperty(top, name2, value) || !this.digester.getRulesValidation() || "optional".equals(name2)) continue;
            this.digester.log.warn(sm.getString("rule.noProperty", this.digester.match, name2, value));
        }
        if (top instanceof Listener) {
            ((Listener)top).endSetPropertiesRule();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetPropertiesRule[");
        sb.append("]");
        return sb.toString();
    }

    public static interface Listener {
        public void endSetPropertiesRule();
    }
}

