/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class NioBlockingSelector {
    private static final Log log = LogFactory.getLog(NioBlockingSelector.class);
    protected static final StringManager sm = StringManager.getManager(NioBlockingSelector.class);
    private final SynchronizedStack<KeyReference> keyReferenceStack = new SynchronizedStack();
    protected Selector sharedSelector;
    protected BlockPoller poller;

    public void open(String name2, Selector selector) {
        this.sharedSelector = selector;
        this.poller = new BlockPoller();
        this.poller.selector = this.sharedSelector;
        this.poller.setDaemon(true);
        this.poller.setName(name2 + "-BlockPoller");
        this.poller.start();
    }

    public void close() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller.interrupt();
            this.poller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buf, NioChannel socket, long writeTimeout) throws IOException {
        SelectionKey key2 = socket.getIOChannel().keyFor(socket.getSocketWrapper().getPoller().getSelector());
        if (key2 == null) {
            throw new IOException(sm.getString("nioBlockingSelector.keyNotRegistered"));
        }
        KeyReference reference = this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key2.attachment();
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time2 = System.currentTimeMillis();
        try {
            while (!timedout && buf.hasRemaining()) {
                if (keycount > 0) {
                    int cnt = socket.write(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time2 = System.currentTimeMillis();
                        continue;
                    }
                }
                try {
                    if (att.getWriteLatch() == null || att.getWriteLatch().getCount() == 0L) {
                        att.startWriteLatch(1);
                    }
                    this.poller.add(att, 4, reference);
                    att.awaitWriteLatch(AbstractEndpoint.toTimeout(writeTimeout), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getWriteLatch() != null && att.getWriteLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetWriteLatch();
                }
                if (writeTimeout <= 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time2 >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 4);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push(reference);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, NioChannel socket, long readTimeout) throws IOException {
        SelectionKey key2 = socket.getIOChannel().keyFor(socket.getSocketWrapper().getPoller().getSelector());
        if (key2 == null) {
            throw new IOException(sm.getString("nioBlockingSelector.keyNotRegistered"));
        }
        KeyReference reference = this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key2.attachment();
        int read2 = 0;
        boolean timedout = false;
        int keycount = 1;
        long time2 = System.currentTimeMillis();
        try {
            while (!(timedout || keycount > 0 && (read2 = socket.read(buf)) != 0)) {
                try {
                    if (att.getReadLatch() == null || att.getReadLatch().getCount() == 0L) {
                        att.startReadLatch(1);
                    }
                    this.poller.add(att, 1, reference);
                    att.awaitReadLatch(AbstractEndpoint.toTimeout(readTimeout), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getReadLatch() != null && att.getReadLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetReadLatch();
                }
                if (readTimeout < 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time2 >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 1);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push(reference);
        }
        return read2;
    }

    public static class KeyReference {
        SelectionKey key = null;

        protected void finalize() {
            if (this.key != null && this.key.isValid()) {
                log.warn(sm.getString("nioBlockingSelector.possibleLeak"));
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected static class BlockPoller
    extends Thread {
        protected volatile boolean run = true;
        protected Selector selector = null;
        protected final SynchronizedQueue<Runnable> events = new SynchronizedQueue();
        protected final AtomicInteger wakeupCounter = new AtomicInteger(0);

        protected BlockPoller() {
        }

        public void disable() {
            this.run = false;
            this.selector.wakeup();
        }

        public void cancelKey(SelectionKey key2) {
            RunnableCancel r = new RunnableCancel(key2);
            this.events.offer(r);
            this.wakeup();
        }

        public void wakeup() {
            if (this.wakeupCounter.addAndGet(1) == 0) {
                this.selector.wakeup();
            }
        }

        public void cancel(SelectionKey sk, NioEndpoint.NioSocketWrapper key2, int ops) {
            if (sk != null) {
                sk.cancel();
                sk.attach(null);
                if (4 == (ops & 4)) {
                    this.countDown(key2.getWriteLatch());
                }
                if (1 == (ops & 1)) {
                    this.countDown(key2.getReadLatch());
                }
            }
        }

        public void add(NioEndpoint.NioSocketWrapper key2, int ops, KeyReference ref2) {
            if (key2 == null) {
                return;
            }
            NioChannel nch = (NioChannel)key2.getSocket();
            SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            RunnableAdd r = new RunnableAdd(ch, key2, ops, ref2);
            this.events.offer(r);
            this.wakeup();
        }

        public void remove(NioEndpoint.NioSocketWrapper key2, int ops) {
            if (key2 == null) {
                return;
            }
            NioChannel nch = (NioChannel)key2.getSocket();
            SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            RunnableRemove r = new RunnableRemove(ch, key2, ops);
            this.events.offer(r);
            this.wakeup();
        }

        public boolean events() {
            Runnable r = null;
            int size = this.events.size();
            for (int i = 0; i < size && (r = this.events.poll()) != null; ++i) {
                r.run();
            }
            return size > 0;
        }

        @Override
        public void run() {
            block21: {
                block20: {
                    while (this.run) {
                        try {
                            Iterator<SelectionKey> iterator;
                            this.events();
                            int keyCount = 0;
                            try {
                                int i = this.wakeupCounter.get();
                                if (i > 0) {
                                    keyCount = this.selector.selectNow();
                                } else {
                                    this.wakeupCounter.set(-1);
                                    keyCount = this.selector.select(1000L);
                                }
                                this.wakeupCounter.set(0);
                                if (!this.run) {
                                    break;
                                }
                            }
                            catch (NullPointerException x) {
                                if (this.selector == null) {
                                    throw x;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Possibly encountered sun bug 5076772 on windows JDK 1.5", x);
                                continue;
                            }
                            catch (CancelledKeyException x) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Possibly encountered sun bug 5076772 on windows JDK 1.5", x);
                                continue;
                            }
                            catch (Throwable x) {
                                ExceptionUtils.handleThrowable(x);
                                log.error(sm.getString("nioBlockingSelector.selectError"), x);
                                continue;
                            }
                            Iterator<SelectionKey> iterator2 = iterator = keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                            while (this.run && iterator != null && iterator.hasNext()) {
                                SelectionKey sk = iterator.next();
                                NioEndpoint.NioSocketWrapper socketWrapper = (NioEndpoint.NioSocketWrapper)sk.attachment();
                                try {
                                    iterator.remove();
                                    sk.interestOps(sk.interestOps() & ~sk.readyOps());
                                    if (sk.isReadable()) {
                                        this.countDown(socketWrapper.getReadLatch());
                                    }
                                    if (!sk.isWritable()) continue;
                                    this.countDown(socketWrapper.getWriteLatch());
                                }
                                catch (CancelledKeyException ckx) {
                                    sk.cancel();
                                    this.countDown(socketWrapper.getReadLatch());
                                    this.countDown(socketWrapper.getWriteLatch());
                                }
                            }
                        }
                        catch (Throwable t) {
                            log.error(sm.getString("nioBlockingSelector.processingError"), t);
                        }
                    }
                    this.events.clear();
                    if (this.selector.isOpen()) {
                        try {
                            this.selector.selectNow();
                        }
                        catch (Exception ignore) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug("", ignore);
                        }
                    }
                }
                try {
                    this.selector.close();
                }
                catch (Exception ignore) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug("", ignore);
                }
            }
        }

        public void countDown(CountDownLatch latch) {
            if (latch == null) {
                return;
            }
            latch.countDown();
        }

        public static class RunnableCancel
        implements Runnable {
            private final SelectionKey key;

            public RunnableCancel(SelectionKey key2) {
                this.key = key2;
            }

            @Override
            public void run() {
                this.key.cancel();
            }
        }

        private class RunnableRemove
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;

            public RunnableRemove(SocketChannel ch, NioEndpoint.NioSocketWrapper key2, int ops) {
                this.ch = ch;
                this.key = key2;
                this.ops = ops;
            }

            @Override
            public void run() {
                block11: {
                    SelectionKey sk = this.ch.keyFor(BlockPoller.this.selector);
                    try {
                        if (sk == null) {
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                        } else if (sk.isValid()) {
                            sk.interestOps(sk.interestOps() & ~this.ops);
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                            if (sk.interestOps() == 0) {
                                sk.cancel();
                                sk.attach(null);
                            }
                        } else {
                            sk.cancel();
                            sk.attach(null);
                        }
                    }
                    catch (CancelledKeyException cx) {
                        if (sk == null) break block11;
                        sk.cancel();
                        sk.attach(null);
                    }
                }
            }
        }

        private class RunnableAdd
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;
            private final KeyReference ref;

            public RunnableAdd(SocketChannel ch, NioEndpoint.NioSocketWrapper key2, int ops, KeyReference ref2) {
                this.ch = ch;
                this.key = key2;
                this.ops = ops;
                this.ref = ref2;
            }

            @Override
            public void run() {
                SelectionKey sk = this.ch.keyFor(BlockPoller.this.selector);
                try {
                    if (sk == null) {
                        this.ref.key = sk = this.ch.register(BlockPoller.this.selector, this.ops, this.key);
                    } else if (!sk.isValid()) {
                        BlockPoller.this.cancel(sk, this.key, this.ops);
                    } else {
                        sk.interestOps(sk.interestOps() | this.ops);
                    }
                }
                catch (CancelledKeyException cx) {
                    BlockPoller.this.cancel(sk, this.key, this.ops);
                }
                catch (ClosedChannelException cx) {
                    BlockPoller.this.cancel(null, this.key, this.ops);
                }
            }
        }
    }
}

