/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.reader;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jboss.interceptor.builder.MethodReference;
import org.jboss.interceptor.reader.AnnotatedMethodReader;
import org.jboss.interceptor.reader.ReflectiveAnnotatedMethodReader;
import org.jboss.interceptor.spi.metadata.MethodMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.interceptor.util.InterceptionTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodMetadata<M>
implements MethodMetadata,
Serializable {
    private static final long serialVersionUID = -4538617003189564552L;
    private Method javaMethod;
    private Set<InterceptionType> supportedInterceptorTypes = new HashSet<InterceptionType>();

    private DefaultMethodMetadata(M methodReference, AnnotatedMethodReader<M> annotationReader) {
        this.javaMethod = annotationReader.getJavaMethod(methodReference);
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (annotationReader.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType), methodReference) == null) continue;
            this.supportedInterceptorTypes.add(interceptionType);
        }
    }

    private DefaultMethodMetadata(Set<InterceptionType> interceptionTypes, MethodReference methodReference) {
        this.supportedInterceptorTypes = interceptionTypes;
        try {
            this.javaMethod = methodReference.getDeclaringClass().getDeclaredMethod(methodReference.getMethodName(), methodReference.getParameterTypes());
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static <M> MethodMetadata of(M methodReference, AnnotatedMethodReader<M> methodReader) {
        return new DefaultMethodMetadata<M>(methodReference, methodReader);
    }

    public static MethodMetadata of(Method method) {
        return new DefaultMethodMetadata<Method>(method, new ReflectiveAnnotatedMethodReader());
    }

    @Override
    public Set<InterceptionType> getSupportedInterceptionTypes() {
        return this.supportedInterceptorTypes;
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public Class<?> getReturnType() {
        return this.javaMethod.getReturnType();
    }

    private Object writeReplace() {
        return new DefaultMethodMetadataSerializationProxy(this.supportedInterceptorTypes, MethodReference.of(this, true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultMethodMetadataSerializationProxy
    implements Serializable {
        private Set<InterceptionType> supportedInterceptionTypes;
        private MethodReference methodReference;

        private DefaultMethodMetadataSerializationProxy(Set<InterceptionType> supportedInterceptionTypes, MethodReference methodReference) {
            this.supportedInterceptionTypes = supportedInterceptionTypes;
            this.methodReference = methodReference;
        }

        private Object readResolve() throws ObjectStreamException {
            return new DefaultMethodMetadata(this.supportedInterceptionTypes, this.methodReference);
        }
    }
}

