/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.reader;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorReference;
import org.jboss.interceptor.spi.metadata.MethodMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInterceptorMetadata<T>
implements InterceptorMetadata<T>,
Serializable {
    private static final long serialVersionUID = 1247010247012491L;
    private Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap;
    private final InterceptorReference<T> interceptorReference;
    private boolean targetClass;

    public SimpleInterceptorMetadata(InterceptorReference<T> interceptorReference, boolean targetClass, Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap) {
        this.interceptorReference = interceptorReference;
        this.targetClass = targetClass;
        this.interceptorMethodMap = interceptorMethodMap;
    }

    @Override
    public ClassMetadata<?> getInterceptorClass() {
        return this.interceptorReference.getClassMetadata();
    }

    @Override
    public InterceptorReference<T> getInterceptorReference() {
        return this.interceptorReference;
    }

    @Override
    public boolean isTargetClass() {
        return this.targetClass;
    }

    @Override
    public List<MethodMetadata> getInterceptorMethods(InterceptionType interceptionType) {
        if (this.interceptorMethodMap != null) {
            List<MethodMetadata> methods2 = this.interceptorMethodMap.get((Object)interceptionType);
            return methods2 == null ? Collections.emptyList() : methods2;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEligible(InterceptionType interceptionType) {
        if (this.interceptorMethodMap == null) {
            return false;
        }
        List<MethodMetadata> interceptorMethods = this.interceptorMethodMap.get((Object)interceptionType);
        return interceptorMethods != null && !interceptorMethods.isEmpty();
    }
}

