/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.AbstractLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.Slf4jLocationAwareLogger;
import org.jboss.logging.Slf4jLogger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

final class Slf4jLoggerProvider
extends AbstractLoggerProvider
implements LoggerProvider {
    Slf4jLoggerProvider() {
    }

    @Override
    public Logger getLogger(String name2) {
        org.slf4j.Logger l = LoggerFactory.getLogger(name2);
        if (l instanceof LocationAwareLogger) {
            return new Slf4jLocationAwareLogger(name2, (LocationAwareLogger)l);
        }
        return new Slf4jLogger(name2, l);
    }

    @Override
    public void clearMdc() {
        MDC.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putMdc(String key2, Object value) {
        try {
            String string2 = MDC.get(key2);
            return string2;
        }
        finally {
            if (value == null) {
                MDC.remove(key2);
            } else {
                MDC.put(key2, String.valueOf(value));
            }
        }
    }

    @Override
    public Object getMdc(String key2) {
        return MDC.get(key2);
    }

    @Override
    public void removeMdc(String key2) {
        MDC.remove(key2);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        Map copy2 = MDC.getCopyOfContextMap();
        return copy2 == null ? Collections.emptyMap() : new LinkedHashMap(copy2);
    }
}

