/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jboss.threads.ContextClassLoaderSavingRunnable;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.Messages;
import org.jboss.threads.ThreadNameInfo;
import org.jboss.threads.Version;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionObjLongConsumer;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.Functions;

public class JBossThread
extends Thread {
    private static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private volatile InterruptHandler interruptHandler;
    private ThreadNameInfo threadNameInfo;
    private List<Runnable> exitHandlers;
    private static final int STATE_MAYBE_INTERRUPTED = 0;
    private static final int STATE_INTERRUPT_DEFERRED = 1;
    private static final int STATE_INTERRUPT_PENDING = 2;
    private static final int STATE_INTERRUPT_IN_PROGRESS = 3;
    private final AtomicInteger stateRef = new AtomicInteger();

    public JBossThread(Runnable target) {
        super(target);
    }

    public JBossThread(Runnable target, String name2) {
        super(target, name2);
    }

    public JBossThread(ThreadGroup group, Runnable target) throws SecurityException {
        super(group, target);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name2) throws SecurityException {
        super(group, target, name2);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name2, long stackSize) throws SecurityException {
        super(group, target, name2, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        int newVal;
        int oldVal;
        boolean differentThread;
        boolean bl = differentThread = Thread.currentThread() != this;
        if (differentThread) {
            this.checkAccess();
        }
        if (this.isInterrupted()) {
            return;
        }
        AtomicInteger stateRef = this.stateRef;
        do {
            if ((oldVal = stateRef.get()) != 2 && oldVal != 3) continue;
            Messages.msg.tracef("Interrupting thread \"%s\" (already interrupted)", (Object)this);
            return;
        } while (!stateRef.compareAndSet(oldVal, newVal = oldVal == 1 ? 2 : 3));
        if (newVal == 3) {
            try {
                this.doInterrupt();
            }
            finally {
                stateRef.set(0);
                if (differentThread) {
                    LockSupport.unpark(this);
                }
            }
        } else {
            Messages.intMsg.tracef("Interrupting thread \"%s\" (deferred)", (Object)this);
        }
    }

    private void doInterrupt() {
        if (this.isInterrupted()) {
            return;
        }
        Messages.msg.tracef("Interrupting thread \"%s\"", (Object)this);
        try {
            super.interrupt();
        }
        finally {
            InterruptHandler interruptHandler = this.interruptHandler;
            if (interruptHandler != null) {
                try {
                    interruptHandler.handleInterrupt(this);
                }
                catch (Throwable t) {
                    Messages.msg.interruptHandlerThrew(t, interruptHandler);
                }
            }
        }
    }

    @Override
    public boolean isInterrupted() {
        return this == Thread.currentThread() ? super.isInterrupted() : super.isInterrupted() || this.stateRef.get() == 2;
    }

    public static void executeWithInterruptDeferred(Runnable task) {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                task.run();
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        } else {
            task.run();
        }
    }

    public static <T> T executeWithInterruptDeferred(Callable<T> action) throws Exception {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                T t = action.call();
                return t;
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        }
        return action.call();
    }

    public static <T> T executeWithInterruptDeferred(PrivilegedAction<T> action) {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                T t = action.run();
                return t;
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        }
        return action.run();
    }

    public static <T> T executeWithInterruptDeferred(PrivilegedExceptionAction<T> action) throws Exception {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                T t = action.run();
                return t;
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        }
        return action.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R, E extends Exception> R applyInterruptDeferredEx(ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                R r = function.apply(param1, param2);
                return r;
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        }
        return function.apply(param1, param2);
    }

    public static <T, R, E extends Exception> R applyInterruptDeferredEx(ExceptionFunction<T, R, E> function, T param) throws E {
        return JBossThread.applyInterruptDeferredEx(Functions.exceptionFunctionBiFunction(), function, param);
    }

    public static <T, E extends Exception> T getInterruptDeferredEx(ExceptionSupplier<T, E> supplier) throws E {
        return (T)JBossThread.applyInterruptDeferredEx(Functions.exceptionFunctionBiFunction(), Functions.exceptionSupplierFunction(), supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptInterruptDeferredEx(ExceptionObjLongConsumer<T, E> consumer, T param1, long param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptInterruptDeferredEx(ExceptionObjIntConsumer<T, E> consumer, T param1, int param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, E extends Exception> void acceptInterruptDeferredEx(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.registerDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.unregisterDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    public static <T, E extends Exception> void acceptInterruptDeferredEx(ExceptionConsumer<T, E> consumer, T param) throws E {
        JBossThread.acceptInterruptDeferredEx(Functions.exceptionConsumerBiConsumer(), consumer, param);
    }

    public static <E extends Exception> void runInterruptDeferredEx(ExceptionRunnable<E> runnable) throws E {
        JBossThread.acceptInterruptDeferredEx(Functions.exceptionConsumerBiConsumer(), Functions.exceptionRunnableConsumer(), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R, E extends Exception> R applyInterruptResumedEx(ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.unregisterDeferral(thread2)) {
            try {
                R r = function.apply(param1, param2);
                return r;
            }
            finally {
                JBossThread.registerDeferral(thread2);
            }
        }
        return function.apply(param1, param2);
    }

    public static <T, R, E extends Exception> R applyInterruptResumedEx(ExceptionFunction<T, R, E> function, T param) throws E {
        return JBossThread.applyInterruptResumedEx(Functions.exceptionFunctionBiFunction(), function, param);
    }

    public static <T, E extends Exception> T getInterruptResumedEx(ExceptionSupplier<T, E> supplier) throws E {
        return (T)JBossThread.applyInterruptResumedEx(Functions.exceptionFunctionBiFunction(), Functions.exceptionSupplierFunction(), supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptInterruptResumedEx(ExceptionObjLongConsumer<T, E> consumer, T param1, long param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.unregisterDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.registerDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptInterruptResumedEx(ExceptionObjIntConsumer<T, E> consumer, T param1, int param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.unregisterDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.registerDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, E extends Exception> void acceptInterruptResumedEx(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (JBossThread.unregisterDeferral(thread2)) {
            try {
                consumer.accept(param1, param2);
            }
            finally {
                JBossThread.registerDeferral(thread2);
            }
        } else {
            consumer.accept(param1, param2);
        }
    }

    public static <T, E extends Exception> void acceptInterruptResumedEx(ExceptionConsumer<T, E> consumer, T param) throws E {
        JBossThread.acceptInterruptResumedEx(Functions.exceptionConsumerBiConsumer(), consumer, param);
    }

    public static <E extends Exception> void runInterruptResumedEx(ExceptionRunnable<E> runnable) throws E {
        JBossThread.acceptInterruptResumedEx(Functions.exceptionConsumerBiConsumer(), Functions.exceptionRunnableConsumer(), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterDeferral(JBossThread thread2) {
        int newVal;
        int oldVal;
        if (thread2 == null) {
            return false;
        }
        AtomicInteger stateRef = thread2.stateRef;
        do {
            if ((oldVal = stateRef.get()) == 0 || oldVal == 3) {
                return false;
            }
            if (oldVal == 1) {
                newVal = 0;
                continue;
            }
            if (oldVal == 2) {
                newVal = 3;
                continue;
            }
            throw Assert.unreachableCode();
        } while (!stateRef.compareAndSet(oldVal, newVal));
        if (newVal == 3) {
            try {
                thread2.doInterrupt();
            }
            finally {
                stateRef.set(0);
            }
        }
        return true;
    }

    private static boolean registerDeferral(JBossThread thread2) {
        int newVal;
        int oldVal;
        if (thread2 == null) {
            return false;
        }
        AtomicInteger stateRef = thread2.stateRef;
        do {
            oldVal = stateRef.get();
            while (oldVal == 3) {
                LockSupport.park();
                oldVal = stateRef.get();
            }
            if (oldVal != 0) {
                if (oldVal == 1 || oldVal == 2) {
                    return false;
                }
                throw Assert.unreachableCode();
            }
            newVal = Thread.interrupted() ? 1 : 2;
        } while (!stateRef.compareAndSet(oldVal, newVal));
        if (newVal == 1 && Thread.interrupted()) {
            stateRef.set(2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Messages.msg.tracef("Thread \"%s\" starting execution", (Object)this);
        try {
            super.run();
        }
        finally {
            Messages.msg.tracef("Thread \"%s\" exiting", (Object)this);
            List<Runnable> exitHandlers = this.exitHandlers;
            if (exitHandlers != null) {
                for (Runnable exitHandler : exitHandlers) {
                    try {
                        exitHandler.run();
                    }
                    catch (Throwable t) {
                        try {
                            this.getUncaughtExceptionHandler().uncaughtException(this, t);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    public static boolean onExit(Runnable hook) throws SecurityException {
        JBossThread thread2;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MODIFY_THREAD_PERMISSION);
        }
        if ((thread2 = JBossThread.currentThread()) == null || hook == null) {
            return false;
        }
        List<Runnable> exitHandlers = thread2.exitHandlers;
        if (exitHandlers == null) {
            thread2.exitHandlers = exitHandlers = new ArrayList<Runnable>();
        }
        exitHandlers.add(new ContextClassLoaderSavingRunnable(JBossExecutors.getContextClassLoader(thread2), hook));
        return true;
    }

    public static JBossThread currentThread() {
        Thread thread2 = Thread.currentThread();
        return thread2 instanceof JBossThread ? (JBossThread)thread2 : null;
    }

    @Override
    public void start() {
        super.start();
        Messages.msg.tracef("Started thread \"%s\"", (Object)this);
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        super.setUncaughtExceptionHandler(eh);
        Messages.msg.tracef("Changed uncaught exception handler for \"%s\" to %s", (Object)this, (Object)eh);
    }

    public static InterruptHandler getAndSetInterruptHandler(InterruptHandler newInterruptHandler) {
        JBossThread thread2 = JBossThread.currentThread();
        if (thread2 == null) {
            throw Messages.msg.noInterruptHandlers();
        }
        try {
            InterruptHandler interruptHandler = thread2.interruptHandler;
            return interruptHandler;
        }
        finally {
            thread2.interruptHandler = newInterruptHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R, E extends Exception> R applyWithInterruptHandler(InterruptHandler interruptHandler, ExceptionBiFunction<T, U, R, E> function, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (thread2 == null) {
            return function.apply(param1, param2);
        }
        InterruptHandler old = thread2.interruptHandler;
        thread2.interruptHandler = interruptHandler;
        try {
            R r = function.apply(param1, param2);
            return r;
        }
        finally {
            thread2.interruptHandler = old;
        }
    }

    public static <T, R, E extends Exception> R applyWithInterruptHandler(InterruptHandler interruptHandler, ExceptionFunction<T, R, E> function, T param1) throws E {
        return JBossThread.applyWithInterruptHandler(interruptHandler, Functions.exceptionFunctionBiFunction(), function, param1);
    }

    public static <R, E extends Exception> R getWithInterruptHandler(InterruptHandler interruptHandler, ExceptionSupplier<R, E> function) throws E {
        return JBossThread.applyWithInterruptHandler(interruptHandler, Functions.exceptionFunctionBiFunction(), Functions.exceptionSupplierFunction(), function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptWithInterruptHandler(InterruptHandler interruptHandler, ExceptionObjLongConsumer<T, E> function, T param1, long param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (thread2 == null) {
            function.accept(param1, param2);
            return;
        }
        InterruptHandler old = thread2.interruptHandler;
        thread2.interruptHandler = interruptHandler;
        try {
            function.accept(param1, param2);
            return;
        }
        finally {
            thread2.interruptHandler = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void acceptWithInterruptHandler(InterruptHandler interruptHandler, ExceptionObjIntConsumer<T, E> function, T param1, int param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (thread2 == null) {
            function.accept(param1, param2);
            return;
        }
        InterruptHandler old = thread2.interruptHandler;
        thread2.interruptHandler = interruptHandler;
        try {
            function.accept(param1, param2);
            return;
        }
        finally {
            thread2.interruptHandler = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, E extends Exception> void acceptWithInterruptHandler(InterruptHandler interruptHandler, ExceptionBiConsumer<T, U, E> function, T param1, U param2) throws E {
        JBossThread thread2 = JBossThread.currentThread();
        if (thread2 == null) {
            function.accept(param1, param2);
            return;
        }
        InterruptHandler old = thread2.interruptHandler;
        thread2.interruptHandler = interruptHandler;
        try {
            function.accept(param1, param2);
            return;
        }
        finally {
            thread2.interruptHandler = old;
        }
    }

    public static <T, E extends Exception> void acceptWithInterruptHandler(InterruptHandler interruptHandler, ExceptionConsumer<T, E> function, T param1) throws E {
        JBossThread.acceptWithInterruptHandler(interruptHandler, Functions.exceptionConsumerBiConsumer(), function, param1);
    }

    public static <E extends Exception> void runWithInterruptHandler(InterruptHandler interruptHandler, ExceptionRunnable<E> function) throws E {
        JBossThread.acceptWithInterruptHandler(interruptHandler, Functions.exceptionConsumerBiConsumer(), Functions.exceptionRunnableConsumer(), function);
    }

    ThreadNameInfo getThreadNameInfo() {
        return this.threadNameInfo;
    }

    void setThreadNameInfo(ThreadNameInfo threadNameInfo) throws SecurityException {
        this.checkAccess();
        this.threadNameInfo = threadNameInfo;
    }

    static {
        Version.getVersionString();
    }
}

