/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.ForwardingInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"}, justification="Uses SerializationProxy")
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;

    public static <I> Instance<I> of(InjectionPoint injectionPoint, CreationalContext<I> creationalContext, BeanManagerImpl beanManager) {
        return new InstanceImpl<I>(injectionPoint, creationalContext, beanManager);
    }

    private InstanceImpl(InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        super(injectionPoint, creationalContext, beanManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Resolvable resolvable = new ResolvableBuilder(this.getType(), this.getBeanManager()).addQualifiers(this.getQualifiers()).setDeclaringBean(this.getInjectionPoint().getBean()).create();
        Bean bean2 = this.getBeanManager().getBean(resolvable);
        InstanceInjectionPoint ip = new InstanceInjectionPoint(this.getInjectionPoint(), this.getType(), this.getQualifiers());
        CurrentInjectionPoint currentInjectionPoint = Container.instance().services().get(CurrentInjectionPoint.class);
        try {
            currentInjectionPoint.push(ip);
            Object t = Reflections.cast(this.getBeanManager().getReference(bean2, this.getType(), this.getCreationalContext()));
            return t;
        }
        finally {
            currentInjectionPoint.pop();
        }
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Instance<" + Formats.formatType(this.getType()) + ">";
    }

    private Set<Bean<?>> getBeans() {
        return this.getBeanManager().getBeans(this.getType(), this.getQualifiers());
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList instances = new ArrayList();
        for (Bean<?> bean2 : this.getBeans()) {
            if (InjectionPoint.class.isAssignableFrom(bean2.getBeanClass())) continue;
            Object object = this.getBeanManager().getReference(bean2, this.getType(), this.getBeanManager().createCreationalContext((Contextual)bean2));
            instances.add(Reflections.cast(object));
        }
        return instances.iterator();
    }

    @Override
    public boolean isAmbiguous() {
        return this.getBeans().size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        return this.getBeans().size() == 0;
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        return this.selectInstance(this.getType(), qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype, qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype.getType(), qualifiers);
    }

    private <U extends T> Instance<U> selectInstance(Type subtype, Annotation[] newQualifiers) {
        FacadeInjectionPoint modifiedInjectionPoint = new FacadeInjectionPoint(this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers);
        return new InstanceImpl(modifiedInjectionPoint, this.getCreationalContext(), this.getBeanManager());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Instance<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(InstanceImpl<T> instance) {
            super(instance);
        }

        private Object readResolve() {
            return InstanceImpl.of(this.getInjectionPoint(), this.getCreationalContext(), this.getBeanManager());
        }
    }

    private static class InstanceInjectionPoint
    extends ForwardingInjectionPoint
    implements Serializable {
        private static final long serialVersionUID = -4102173765226078459L;
        private final InjectionPoint injectionPoint;
        private final Type type;
        private final Set<Annotation> qualifiers;

        public InstanceInjectionPoint(InjectionPoint injectionPoint, Type type2, Set<Annotation> qualifiers) {
            this.injectionPoint = injectionPoint;
            this.type = type2;
            this.qualifiers = qualifiers;
        }

        @Override
        protected InjectionPoint delegate() {
            return this.injectionPoint;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

