/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.AbstractBeanInstance;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;

public class ContextBeanInstance<T>
extends AbstractBeanInstance
implements Serializable {
    private static final long serialVersionUID = -8144230657830556503L;
    private transient Bean<T> bean;
    private final String id;
    private final Class<?> instanceType;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ContextBeanInstance(Bean<T> bean2, String id) {
        this.bean = bean2;
        this.id = id;
        this.instanceType = this.computeInstanceType(bean2);
        log.trace("Created context instance locator for bean " + bean2 + " identified as " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() {
        Context context;
        T existingInstance;
        Container container = Container.instance();
        if (this.bean == null) {
            this.bean = (Bean)container.services().get(ContextualStore.class).getContextual(this.id);
        }
        if ((existingInstance = (context = container.deploymentManager().getContext(this.bean.getScope())).get(this.bean)) != null) {
            return existingInstance;
        }
        WeldCreationalContext<?> previousCreationalContext = currentCreationalContext.get();
        WeldCreationalContext<T> creationalContext = currentCreationalContext.get() == null ? new CreationalContextImpl<T>(this.bean) : currentCreationalContext.get().getCreationalContext(this.bean);
        CurrentInjectionPoint currentInjectionPoint = container.services().get(CurrentInjectionPoint.class);
        currentCreationalContext.set(creationalContext);
        try {
            currentInjectionPoint.push(EmptyInjectionPoint.INSTANCE);
            T t = context.get(this.bean, creationalContext);
            return t;
        }
        finally {
            currentInjectionPoint.pop();
            if (previousCreationalContext == null) {
                currentCreationalContext.remove();
            } else {
                currentCreationalContext.set(previousCreationalContext);
            }
        }
    }

    public Class<T> getInstanceType() {
        return (Class)Reflections.cast(this.instanceType);
    }
}

