/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.el;

import java.util.HashMap;
import java.util.Map;

public class Namespace {
    private final String qualifiedName;
    private final String name;
    private final Map<String, Namespace> children;

    public Namespace(Iterable<String> namespaces) {
        this(null, null);
        for (String namespace2 : namespaces) {
            String[] hierarchy = namespace2.split("\\.");
            Namespace n = this;
            for (String s : hierarchy) {
                n = n.putIfAbsent(s);
            }
        }
    }

    protected Namespace(String name2, String qualifiedName) {
        this.name = name2;
        this.qualifiedName = qualifiedName;
        this.children = new HashMap<String, Namespace>();
    }

    private Namespace putIfAbsent(String key2) {
        Namespace result = this.children.get(key2);
        if (result == null) {
            result = new Namespace(key2, this.qualifyName(key2));
            this.children.put(key2, result);
        }
        return result;
    }

    public Namespace get(String key2) {
        return this.children.get(key2);
    }

    public boolean contains(String key2) {
        return this.children.containsKey(key2);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    protected Map<String, Namespace> getChildren() {
        return this.children;
    }

    protected String getName() {
        return this.name;
    }

    public String qualifyName(String suffix) {
        return this.qualifiedName == null ? suffix : this.qualifiedName + "." + suffix;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Namespace) {
            Namespace that = (Namespace)other;
            return this.getQualifiedName().equals(that.getQualifiedName());
        }
        return false;
    }

    public String toString() {
        return "Namespace(" + (this.name == null ? "Root" : this.name) + ')';
    }

    public void clear() {
    }
}

