/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.exceptions;

import java.io.Serializable;
import org.jboss.weld.exceptions.WeldExceptionMessage;
import org.jboss.weld.logging.LoggerFactory;

public class WeldExceptionKeyMessage
implements WeldExceptionMessage,
Serializable {
    private static final long serialVersionUID = 3474682221381024558L;
    private Enum<?> messageKey;
    private String[] messageArguments;

    public <E extends Enum<?>> WeldExceptionKeyMessage(E key2, Object ... args) {
        this.messageKey = key2;
        if (args != null && args.length > 0) {
            this.messageArguments = new String[args.length];
            int index2 = 0;
            for (Object arg : args) {
                this.messageArguments[index2++] = arg == null ? "null" : arg.toString();
            }
        }
    }

    @Override
    public String getAsString() {
        String result = null;
        try {
            result = LoggerFactory.loggerFactory().getMessageConveyor().getMessage(this.messageKey, this.messageArguments);
        }
        catch (Exception e2) {
            result = "Exception message for key " + this.messageKey + " not found due to " + e2.getLocalizedMessage();
        }
        if (result == null) {
            result = "Exception message for key " + this.messageKey + " not found";
        }
        return result;
    }
}

