/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.SimpleMethodInvocation;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInterceptionChain
implements InterceptionChain {
    private static final Logger log = LoggerFactory.getLogger(SimpleInterceptionChain.class);
    private final Object target;
    private final Method targetMethod;
    private int currentPosition;
    private final List<InterceptorMethodInvocation> interceptorMethodInvocations;

    public SimpleInterceptionChain(Collection<InterceptorInvocation> interceptorInvocations, Object target, Method targetMethod) {
        this.target = target;
        this.targetMethod = targetMethod;
        this.currentPosition = 0;
        this.interceptorMethodInvocations = new ArrayList<InterceptorMethodInvocation>();
        for (InterceptorInvocation interceptorInvocation : interceptorInvocations) {
            this.interceptorMethodInvocations.addAll(interceptorInvocation.getInterceptorMethodInvocations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeNextInterceptor(InvocationContext invocationContext) throws Throwable {
        try {
            if (!this.hasNextInterceptor()) {
                if (this.targetMethod == null) return null;
                this.targetMethod.setAccessible(true);
                if (invocationContext.getMethod() == null) return this.targetMethod.invoke(this.target, new Object[0]);
                return this.targetMethod.invoke(this.target, invocationContext.getParameters());
            }
            int oldCurrentPosition = this.currentPosition;
            try {
                InterceptorMethodInvocation nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                if (log.isTraceEnabled()) {
                    log.trace("Invoking next interceptor in chain:" + nextInterceptorMethodInvocation.toString());
                }
                if (nextInterceptorMethodInvocation.expectsInvocationContext()) {
                    Object object = nextInterceptorMethodInvocation.invoke(invocationContext);
                    return object;
                }
                nextInterceptorMethodInvocation.invoke(null);
                while (this.hasNextInterceptor()) {
                    nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                    nextInterceptorMethodInvocation.invoke(null);
                }
                Object var4_6 = null;
                return var4_6;
            }
            finally {
                this.currentPosition = oldCurrentPosition;
            }
        }
        catch (InvocationTargetException e2) {
            throw Exceptions.unwrapIfPossible(e2);
        }
    }

    private void validateInterceptor(SimpleMethodInvocation nextInterceptorMethodInvocation, InvocationContext context) {
        int expectedParameters;
        int n = expectedParameters = context == null ? 0 : 1;
        if (nextInterceptorMethodInvocation.method.getJavaMethod().getParameterTypes().length != expectedParameters) {
            throw new IllegalStateException("Mismatch between number of expected and actual parameters on " + nextInterceptorMethodInvocation.getMethod() + ": expected " + expectedParameters + ", actual " + nextInterceptorMethodInvocation.getMethod().getJavaMethod().getParameterTypes().length);
        }
    }

    @Override
    public boolean hasNextInterceptor() {
        return this.currentPosition < this.interceptorMethodInvocations.size();
    }
}

