/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

public class Selectors {
    public static final String DEEP_TREE_MATCH = "**";

    public static boolean matchPath(String pattern, String str2) {
        String[] patDirs = Selectors.tokenize(pattern);
        return Selectors.matchPath(patDirs, Selectors.tokenize(str2), true);
    }

    public static boolean matchPath(String pattern, String str2, boolean isCaseSensitive) {
        String[] patDirs = Selectors.tokenize(pattern);
        return Selectors.matchPath(patDirs, Selectors.tokenize(str2), isCaseSensitive);
    }

    static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = tokenizedPattern.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxStart]).equals(DEEP_TREE_MATCH); ++patIdxStart, ++strIdxStart) {
            if (Selectors.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxEnd]).equals(DEEP_TREE_MATCH)) {
            if (!Selectors.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = tokenizedPattern[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i + j];
                    if (!Selectors.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
            return false;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public static boolean match(String pattern, String str2, boolean caseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str2.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || !Selectors.different(caseSensitive, ch2, strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Selectors.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return Selectors.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Selectors.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return Selectors.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && Selectors.different(caseSensitive, ch, strArr[strIdxStart + i3 + j])) continue block6;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return Selectors.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars2, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (chars2[i] == '*') continue;
            return false;
        }
        return true;
    }

    static String[] tokenize(String str2) {
        Object root2 = null;
        char sep = '.';
        int start = 0;
        int len = str2.length();
        int count2 = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (str2.charAt(pos) != sep) continue;
            if (pos != start) {
                ++count2;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count2;
        }
        String[] l = new String[count2 + (root2 == null ? 0 : 1)];
        if (root2 != null) {
            l[0] = root2;
            count2 = 1;
        } else {
            count2 = 0;
        }
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (str2.charAt(pos) != sep) continue;
            if (pos != start) {
                String tok = str2.substring(start, pos);
                l[count2++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l[count2] = tok = str2.substring(start);
        }
        return l;
    }
}

