/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

public class ClassLoaderResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> classForName(String name2) {
        try {
            return this.classLoader.loadClass(name2);
        }
        catch (ClassNotFoundException e2) {
            throw new ResourceLoadingException("Error loading class " + name2, e2);
        }
        catch (LinkageError e3) {
            throw new ResourceLoadingException("Error loading class " + name2, e3);
        }
        catch (TypeNotPresentException e4) {
            throw new ResourceLoadingException("Error loading class " + name2, e4);
        }
    }

    @Override
    public URL getResource(String name2) {
        return this.classLoader.getResource(name2);
    }

    @Override
    public Collection<URL> getResources(String name2) {
        try {
            return new EnumerationList<URL>(this.classLoader.getResources(name2));
        }
        catch (IOException e2) {
            throw new ResourceLoadingException("Error loading resource " + name2, e2);
        }
    }

    @Override
    public void cleanup() {
        this.classLoader = null;
    }
}

