/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

public class DefaultResourceLoader
implements ResourceLoader {
    public static DefaultResourceLoader INSTANCE = new DefaultResourceLoader();

    protected DefaultResourceLoader() {
    }

    @Override
    public Class<?> classForName(String name2) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return tccl.loadClass(name2);
            }
            return Class.forName(name2);
        }
        catch (ClassNotFoundException e2) {
            throw new ResourceLoadingException("Error loading class " + name2, e2);
        }
        catch (LinkageError e3) {
            throw new ResourceLoadingException("Error loading class " + name2, e3);
        }
        catch (TypeNotPresentException e4) {
            throw new ResourceLoadingException("Error loading class " + name2, e4);
        }
    }

    @Override
    public URL getResource(String name2) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl.getResource(name2);
        }
        return this.getClass().getResource(name2);
    }

    @Override
    public Collection<URL> getResources(String name2) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return new EnumerationList<URL>(tccl.getResources(name2));
            }
            return new EnumerationList<URL>(this.getClass().getClassLoader().getResources(name2));
        }
        catch (IOException e2) {
            throw new ResourceLoadingException("Error loading resource " + name2, e2);
        }
    }

    @Override
    public void cleanup() {
    }
}

