/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class SharedObjectCache
implements Service {
    private final LoadingCache<Set<?>, Set<?>> sharedSets = CacheBuilder.newBuilder().build(new CacheLoader<Set<?>, Set<?>>(){

        @Override
        public Set<?> load(Set<?> from) {
            return Collections.unmodifiableSet(from);
        }
    });
    private final LoadingCache<Map<?, ?>, Map<?, ?>> sharedMaps = CacheBuilder.newBuilder().build(new CacheLoader<Map<?, ?>, Map<?, ?>>(){

        @Override
        public Map<?, ?> load(Map<?, ?> from) {
            return Collections.unmodifiableMap(from);
        }
    });
    private final LoadingCache<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>> sharedMultiMaps = CacheBuilder.newBuilder().build(new CacheLoader<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>>(){

        @Override
        public ArraySetMultimap<?, ?> load(ArraySetMultimap<?, ?> from) {
            return from;
        }
    });
    private final LoadingCache<Type, Set<Type>> typeClosures = CacheBuilder.newBuilder().build(new CacheLoader<Type, Set<Type>>(){

        @Override
        public Set<Type> load(Type from) {
            return Collections.unmodifiableSet(new HierarchyDiscovery(from).getTypeClosure());
        }
    });
    private final LoadingCache<Type, Type> resolvedTypes = CacheBuilder.newBuilder().build(new CacheLoader<Type, Type>(){

        @Override
        public Type load(Type from) {
            return new HierarchyDiscovery(from).getResolvedType();
        }
    });

    public <T> Set<T> getSharedSet(Set<T> set2) {
        return (Set)LoadingCacheUtils.getCastCacheValue(this.sharedSets, set2);
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map2) {
        return (Map)LoadingCacheUtils.getCastCacheValue(this.sharedMaps, map2);
    }

    public <K, V> ArraySetMultimap<K, V> getSharedMultimap(ArraySetMultimap<K, V> map2) {
        return (ArraySetMultimap)LoadingCacheUtils.getCastCacheValue(this.sharedMultiMaps, map2);
    }

    public Set<Type> getTypeClosure(Type type2) {
        return LoadingCacheUtils.getCacheValue(this.typeClosures, type2);
    }

    public Type getResolvedType(Type type2) {
        return LoadingCacheUtils.getCacheValue(this.resolvedTypes, type2);
    }

    @Override
    public void cleanup() {
        this.sharedSets.invalidateAll();
        this.sharedMaps.invalidateAll();
        this.sharedMultiMaps.invalidateAll();
    }
}

