/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.MethodInfo;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;

public class ConstructorUtils {
    private ConstructorUtils() {
    }

    public static void addDefaultConstructor(ClassFile file2, Bytecode initialValueBytecode) {
        ConstructorUtils.addConstructor("()V", new String[0], file2, initialValueBytecode);
    }

    public static void addConstructor(String descriptor2, String[] exceptions, ClassFile file2, Bytecode initialValueBytecode) {
        try {
            MethodInfo ctor = new MethodInfo(file2.getConstPool(), "<init>", descriptor2);
            ctor.setAccessFlags(1);
            ExceptionsAttribute exAt = new ExceptionsAttribute(file2.getConstPool());
            exAt.setExceptions(exceptions);
            ctor.setExceptionsAttribute(exAt);
            Bytecode b = new Bytecode(file2.getConstPool());
            String[] params = DescriptorUtils.descriptorStringToParameterArray(descriptor2);
            b.add(42);
            int localVariableCount = BytecodeUtils.loadParameters(b, descriptor2);
            b.addInvokespecial(file2.getSuperclass(), "<init>", descriptor2);
            b.addAload(0);
            b.addIconst(1);
            b.addPutfield(file2.getName(), "constructed", "Z");
            b.addOpcode(177);
            CodeAttribute ca = b.toCodeAttribute();
            ca.iterator().insert(initialValueBytecode.get());
            ctor.setCodeAttribute(ca);
            ca.setMaxLocals(localVariableCount);
            ca.computeMaxStack();
            file2.addMethod(ctor);
        }
        catch (BadBytecode e2) {
            throw new RuntimeException(e2);
        }
        catch (DuplicateMemberException e3) {
            throw new RuntimeException(e3);
        }
    }
}

