/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Method;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.MethodInfo;
import org.jboss.weld.util.bytecode.MethodInformation;

public class MethodUtils {
    private MethodUtils() {
    }

    public static MethodInfo makeMethod(MethodInformation methodInfo, Class<?>[] exceptions, Bytecode body, ConstPool pool) {
        MethodInfo meth = new MethodInfo(pool, methodInfo.getName(), methodInfo.getDescriptor());
        meth.setAccessFlags(methodInfo.getModifiers());
        String[] ex = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            ex[i] = exceptions[i].getName().replace('.', '/');
        }
        ExceptionsAttribute exAt = new ExceptionsAttribute(pool);
        exAt.setExceptions(ex);
        meth.setExceptionsAttribute(exAt);
        CodeAttribute ca = body.toCodeAttribute();
        meth.setCodeAttribute(ca);
        try {
            ca.computeMaxStack();
        }
        catch (BadBytecode e2) {
            throw new RuntimeException(e2);
        }
        return meth;
    }

    public static int calculateMaxLocals(Method method) {
        int ret = 0;
        if ((method.getModifiers() & 8) == 0) {
            ret = 1;
        }
        ret += method.getParameterTypes().length;
        for (Class<?> i : method.getParameterTypes()) {
            if (i != Double.TYPE && i != Long.TYPE) continue;
            ++ret;
        }
        return ret;
    }
}

