/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Method;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

public class StaticMethodInformation
implements MethodInformation {
    private final String name;
    private final String descriptor;
    private final String[] parameterTypes;
    private final String returnType;
    private final String declaringClass;
    private final int modifiers;

    public StaticMethodInformation(String name2, Class<?>[] parameterTypes, Class<?> returnType, String declaringClass) {
        this(name2, parameterTypes, returnType, declaringClass, 1);
    }

    public StaticMethodInformation(String name2, Class<?>[] parameterTypes, Class<?> returnType, String declaringClass, int modifiers) {
        this.name = name2;
        this.parameterTypes = DescriptorUtils.getParameterTypes(parameterTypes);
        this.returnType = DescriptorUtils.classToStringRepresentation(returnType);
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(this.returnType);
        this.descriptor = builder.toString();
        this.modifiers = modifiers;
    }

    public StaticMethodInformation(String name2, String[] parameterTypes, String returnType, String declaringClass) {
        this.name = name2;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(returnType);
        this.descriptor = builder.toString();
        this.modifiers = 1;
    }

    @Override
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }
}

