/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Arrays2 {
    private Arrays2() {
    }

    public static final boolean containsAll(Object[] array2, Object ... values) {
        return Arrays.asList(array2).containsAll(Arrays.asList(values));
    }

    public static final boolean unorderedEquals(Object[] array2, Object ... values) {
        return Arrays2.containsAll(array2, values) && array2.length == values.length;
    }

    public static <T> Set<T> asSet(T ... array2) {
        HashSet<T> result = new HashSet<T>();
        for (T a : array2) {
            result.add(a);
        }
        return result;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays2.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy2 = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, newLength));
        return copy2;
    }
}

