/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;

abstract class SecureReflectionAccess<T> {
    SecureReflectionAccess() {
    }

    public T run() throws Exception {
        return this.work();
    }

    public T runAndWrap() {
        try {
            return this.run();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public T runAsFieldAccess() throws NoSuchFieldException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)e2.getCause();
            }
            throw new RuntimeException(e2);
        }
        catch (NoSuchFieldException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new RuntimeException(e4);
        }
    }

    public T runAsMethodAccess() throws NoSuchMethodException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e2.getCause();
            }
            throw new RuntimeException(e2);
        }
        catch (NoSuchMethodException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new RuntimeException(e4);
        }
    }

    public T runAsInvocation() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e2.getCause();
            }
            if (e2.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e2.getCause();
            }
            if (e2.getCause() instanceof InvocationTargetException) {
                throw (InvocationTargetException)e2.getCause();
            }
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw e3;
        }
        catch (IllegalArgumentException e4) {
            throw e4;
        }
        catch (InvocationTargetException e5) {
            throw e5;
        }
        catch (Exception e6) {
            throw new RuntimeException(e6);
        }
    }

    public T runAsInstantiation() throws InstantiationException, IllegalAccessException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof InstantiationException) {
                throw (InstantiationException)e2.getCause();
            }
            if (e2.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e2.getCause();
            }
            throw new RuntimeException(e2);
        }
        catch (InstantiationException e3) {
            throw e3;
        }
        catch (IllegalAccessException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new RuntimeException(e5);
        }
    }

    protected abstract T work() throws Exception;
}

