/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.util.reflection.instantiation.Instantiator;

public class ReflectionFactoryInstantiator
implements Instantiator {
    private static final String REFLECTION_CLASS_NAME = "sun.reflect.ReflectionFactory";
    private Method generator = null;
    private Object reflectionFactoryInstance = null;

    private void init() {
        try {
            Class<?> reflectionFactory = Class.forName(REFLECTION_CLASS_NAME);
            Method accessor2 = reflectionFactory.getMethod("getReflectionFactory", new Class[0]);
            this.reflectionFactoryInstance = accessor2.invoke(null, new Object[0]);
            this.generator = reflectionFactory.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isAvailable() {
        this.init();
        return this.generator != null && this.reflectionFactoryInstance != null;
    }

    @Override
    public <T> T instantiate(Class<T> clazz) {
        try {
            Constructor instanceConstructor = (Constructor)this.generator.invoke(this.reflectionFactoryInstance, clazz, Object.class.getDeclaredConstructor(new Class[0]));
            return instanceConstructor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new WeldException(ReflectionMessage.REFLECTIONFACTORY_INSTANTIATION_FAILED, (Throwable)e2, clazz);
        }
    }
}

