/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Configuration;
import org.reflections.ReflectionsException;

public class Store {
    private transient boolean concurrent;
    private final Map<String, Multimap<String, String>> storeMap = new HashMap<String, Multimap<String, String>>();

    protected Store() {
        this.concurrent = false;
    }

    public Store(Configuration configuration) {
        this.concurrent = configuration.getExecutorService() != null;
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    public Multimap<String, String> getOrCreate(String index2) {
        Multimap<String, String> mmap = this.storeMap.get(index2);
        if (mmap == null) {
            SetMultimap<String, String> multimap = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Sets.newSetFromMap(new ConcurrentHashMap());
                }
            });
            mmap = this.concurrent ? Multimaps.synchronizedSetMultimap(multimap) : multimap;
            this.storeMap.put(index2, mmap);
        }
        return mmap;
    }

    public Multimap<String, String> get(String index2) {
        Multimap<String, String> mmap = this.storeMap.get(index2);
        if (mmap == null) {
            throw new ReflectionsException("Scanner " + index2 + " was not configured");
        }
        return mmap;
    }

    public Iterable<String> get(String index2, String ... keys2) {
        return this.get(index2, Arrays.asList(keys2));
    }

    public Iterable<String> get(String index2, Iterable<String> keys2) {
        Multimap<String, String> mmap = this.get(index2);
        IterableChain<String> result = new IterableChain<String>();
        for (String key2 : keys2) {
            ((IterableChain)result).addAll(mmap.get(key2));
        }
        return result;
    }

    private Iterable<String> getAllIncluding(String index2, Iterable<String> keys2, IterableChain<String> result) {
        ((IterableChain)result).addAll(keys2);
        for (String key2 : keys2) {
            Iterable<String> values = this.get(index2, key2);
            if (!values.iterator().hasNext()) continue;
            this.getAllIncluding(index2, values, result);
        }
        return result;
    }

    public Iterable<String> getAll(String index2, String key2) {
        return this.getAllIncluding(index2, this.get(index2, key2), new IterableChain<String>());
    }

    public Iterable<String> getAll(String index2, Iterable<String> keys2) {
        return this.getAllIncluding(index2, this.get(index2, keys2), new IterableChain<String>());
    }

    private static class IterableChain<T>
    implements Iterable<T> {
        private final List<Iterable<T>> chain = Lists.newArrayList();

        private IterableChain() {
        }

        private void addAll(Iterable<T> iterable) {
            this.chain.add(iterable);
        }

        @Override
        public Iterator<T> iterator() {
            return Iterables.concat(this.chain).iterator();
        }
    }
}

