/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.Utils;

public class JavaCodeSerializer
implements Serializer {
    private static final String pathSeparator = "_";
    private static final String doubleSeparator = "__";
    private static final String dotSeparator = ".";
    private static final String arrayDescriptor = "$$";
    private static final String tokenSeparator = "_";

    @Override
    public Reflections read(InputStream inputStream) {
        throw new UnsupportedOperationException("read is not implemented on JavaCodeSerializer");
    }

    @Override
    public File save(Reflections reflections, String name2) {
        String className;
        String packageName;
        if (name2.endsWith("/")) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        String filename = name2.replace('.', '/').concat(".java");
        File file2 = Utils.prepareFile(filename);
        int lastDot = name2.lastIndexOf(46);
        if (lastDot == -1) {
            packageName = "";
            className = name2.substring(name2.lastIndexOf(47) + 1);
        } else {
            packageName = name2.substring(name2.lastIndexOf(47) + 1, lastDot);
            className = name2.substring(lastDot + 1);
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("//generated using Reflections JavaCodeSerializer").append(" [").append(new Date()).append("]").append("\n");
            if (packageName.length() != 0) {
                sb.append("package ").append(packageName).append(";\n");
                sb.append("\n");
            }
            sb.append("public interface ").append(className).append(" {\n\n");
            sb.append(this.toString(reflections));
            sb.append("}\n");
            Files.write(sb.toString(), new File(filename), Charset.defaultCharset());
        }
        catch (IOException e2) {
            throw new RuntimeException();
        }
        return file2;
    }

    @Override
    public String toString(Reflections reflections) {
        if (reflections.getStore().get(TypeElementsScanner.class.getSimpleName()).isEmpty() && Reflections.log != null) {
            Reflections.log.warn("JavaCodeSerializer needs TypeElementsScanner configured");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> prevPaths = Lists.newArrayList();
        int indent2 = 1;
        ArrayList<String> keys2 = Lists.newArrayList(reflections.getStore().get(TypeElementsScanner.class.getSimpleName()).keySet());
        Collections.sort(keys2);
        for (String fqn : keys2) {
            int j;
            int i;
            ArrayList<String> typePaths = Lists.newArrayList(fqn.split("\\."));
            for (i = 0; i < Math.min(typePaths.size(), prevPaths.size()) && ((String)typePaths.get(i)).equals(prevPaths.get(i)); ++i) {
            }
            for (j = prevPaths.size(); j > i; --j) {
                sb.append(Utils.repeat("\t", --indent2)).append("}\n");
            }
            for (j = i; j < typePaths.size() - 1; ++j) {
                sb.append(Utils.repeat("\t", indent2++)).append("public interface ").append(this.getNonDuplicateName((String)typePaths.get(j), typePaths, j)).append(" {\n");
            }
            String className = (String)typePaths.get(typePaths.size() - 1);
            ArrayList<String> annotations = Lists.newArrayList();
            ArrayList<String> fields = Lists.newArrayList();
            SetMultimap<String, String> methods2 = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Sets.newHashSet();
                }
            });
            for (String string2 : reflections.getStore().get(TypeElementsScanner.class.getSimpleName(), fqn)) {
                if (string2.startsWith("@")) {
                    annotations.add(string2.substring(1));
                    continue;
                }
                if (string2.contains("(")) {
                    if (string2.startsWith("<")) continue;
                    int i1 = string2.indexOf(40);
                    String name2 = string2.substring(0, i1);
                    String params = string2.substring(i1 + 1, string2.indexOf(")"));
                    String paramsDescriptor = "";
                    if (params.length() != 0) {
                        paramsDescriptor = "_" + params.replace(dotSeparator, "_").replace(", ", doubleSeparator).replace("[]", arrayDescriptor);
                    }
                    String normalized = name2 + paramsDescriptor;
                    methods2.put(name2, normalized);
                    continue;
                }
                if (Utils.isEmpty(string2)) continue;
                fields.add(string2);
            }
            sb.append(Utils.repeat("\t", indent2++)).append("public interface ").append(this.getNonDuplicateName(className, typePaths, typePaths.size() - 1)).append(" {\n");
            if (!fields.isEmpty()) {
                sb.append(Utils.repeat("\t", indent2++)).append("public interface fields {\n");
                for (String string3 : fields) {
                    sb.append(Utils.repeat("\t", indent2)).append("public interface ").append(this.getNonDuplicateName(string3, typePaths)).append(" {}\n");
                }
                sb.append(Utils.repeat("\t", --indent2)).append("}\n");
            }
            if (!methods2.isEmpty()) {
                sb.append(Utils.repeat("\t", indent2++)).append("public interface methods {\n");
                for (Map.Entry entry : methods2.entries()) {
                    String simpleName = (String)entry.getKey();
                    String normalized = (String)entry.getValue();
                    String methodName = methods2.get(simpleName).size() == 1 ? simpleName : normalized;
                    methodName = this.getNonDuplicateName(methodName, fields);
                    sb.append(Utils.repeat("\t", indent2)).append("public interface ").append(this.getNonDuplicateName(methodName, typePaths)).append(" {}\n");
                }
                sb.append(Utils.repeat("\t", --indent2)).append("}\n");
            }
            if (!annotations.isEmpty()) {
                sb.append(Utils.repeat("\t", indent2++)).append("public interface annotations {\n");
                Iterator<Object> iterator = annotations.iterator();
                while (iterator.hasNext()) {
                    String string4;
                    String nonDuplicateName = string4 = (String)iterator.next();
                    nonDuplicateName = this.getNonDuplicateName(nonDuplicateName, typePaths);
                    sb.append(Utils.repeat("\t", indent2)).append("public interface ").append(nonDuplicateName).append(" {}\n");
                }
                sb.append(Utils.repeat("\t", --indent2)).append("}\n");
            }
            prevPaths = typePaths;
        }
        for (int j = prevPaths.size(); j >= 1; --j) {
            sb.append(Utils.repeat("\t", j)).append("}\n");
        }
        return sb.toString();
    }

    private String getNonDuplicateName(String candidate, List<String> prev2, int offset) {
        String normalized = this.normalize(candidate);
        for (int i = 0; i < offset; ++i) {
            if (!normalized.equals(prev2.get(i))) continue;
            return this.getNonDuplicateName(normalized + "_", prev2, offset);
        }
        return normalized;
    }

    private String normalize(String candidate) {
        return candidate.replace(dotSeparator, "_");
    }

    private String getNonDuplicateName(String candidate, List<String> prev2) {
        return this.getNonDuplicateName(candidate, prev2, prev2.size());
    }

    public static Class<?> resolveClassOf(Class element) throws ClassNotFoundException {
        LinkedList<String> ognl = Lists.newLinkedList();
        for (Class<?> cursor = element; cursor != null; cursor = cursor.getDeclaringClass()) {
            ognl.addFirst(cursor.getSimpleName());
        }
        String classOgnl = Joiner.on(dotSeparator).join(ognl.subList(1, ognl.size())).replace(".$", "$");
        return Class.forName(classOgnl);
    }

    public static Class<?> resolveClass(Class aClass) {
        try {
            return JavaCodeSerializer.resolveClassOf(aClass);
        }
        catch (Exception e2) {
            throw new ReflectionsException("could not resolve to class " + aClass.getName(), e2);
        }
    }

    public static Field resolveField(Class aField) {
        try {
            String name2 = aField.getSimpleName();
            Class<?> declaringClass = aField.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(declaringClass).getDeclaredField(name2);
        }
        catch (Exception e2) {
            throw new ReflectionsException("could not resolve to field " + aField.getName(), e2);
        }
    }

    public static Annotation resolveAnnotation(Class annotation) {
        try {
            String name2 = annotation.getSimpleName().replace("_", dotSeparator);
            Class<?> declaringClass = annotation.getDeclaringClass().getDeclaringClass();
            Class<?> aClass = JavaCodeSerializer.resolveClassOf(declaringClass);
            Class<?> aClass1 = ReflectionUtils.forName(name2, new ClassLoader[0]);
            Object annotation1 = aClass.getAnnotation(aClass1);
            return annotation1;
        }
        catch (Exception e2) {
            throw new ReflectionsException("could not resolve to annotation " + annotation.getName(), e2);
        }
    }

    public static Method resolveMethod(Class aMethod) {
        String methodOgnl = aMethod.getSimpleName();
        try {
            Class[] paramTypes;
            String methodName;
            if (methodOgnl.contains("_")) {
                methodName = methodOgnl.substring(0, methodOgnl.indexOf("_"));
                String[] params = methodOgnl.substring(methodOgnl.indexOf("_") + 1).split(doubleSeparator);
                paramTypes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String typeName = params[i].replace(arrayDescriptor, "[]").replace("_", dotSeparator);
                    paramTypes[i] = ReflectionUtils.forName(typeName, new ClassLoader[0]);
                }
            } else {
                methodName = methodOgnl;
                paramTypes = null;
            }
            Class<?> declaringClass = aMethod.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(declaringClass).getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e2) {
            throw new ReflectionsException("could not resolve to method " + aMethod.getName(), e2);
        }
    }
}

