/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.agent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Date;
import java.util.Properties;
import org.slf4j.instrumentation.LogTransformer;

public class AgentPremain {
    public static void premain(String agentArgument, Instrumentation instrumentation) {
        LogTransformer.Builder builder = new LogTransformer.Builder();
        builder = builder.addEntryExit(true);
        if (agentArgument != null) {
            Properties args = AgentPremain.parseArguments(agentArgument, ",");
            if (args.containsKey("verbose")) {
                builder = builder.verbose(true);
            }
            if (args.containsKey("time")) {
                AgentPremain.printStartStopTimes();
            }
            if (args.containsKey("ignore")) {
                String ignore = args.getProperty("ignore");
                builder = builder.ignore(ignore.split(":"));
            }
            if (args.containsKey("level")) {
                builder = builder.level(args.getProperty("level"));
            }
        }
        instrumentation.addTransformer(builder.build());
    }

    private static Properties parseArguments(String agentArgument, String separator) {
        Properties p = new Properties();
        try {
            String argumentAsLines = agentArgument.replaceAll(separator, "\n");
            p.load(new ByteArrayInputStream(argumentAsLines.getBytes()));
        }
        catch (IOException e2) {
            String s = "Could not load arguments as properties";
            throw new RuntimeException(s, e2);
        }
        return p;
    }

    private static void printStartStopTimes() {
        final long start = System.currentTimeMillis();
        System.err.println("Start at " + new Date());
        Thread hook = new Thread(){

            public void run() {
                long timePassed = System.currentTimeMillis() - start;
                System.err.println("Stop at " + new Date() + ", execution time = " + timePassed + " ms");
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
    }
}

